package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * change_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
public enum ChangeType {

    _1("1", "所属税号变更");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChangeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChangeType fromCode(String code) {
        return Stream.of(ChangeType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
