package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_result_callback_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
public enum InvoiceResultCallbackType {

    _1("1", "单张下发"),
    _2("2", "整单下发");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceResultCallbackType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceResultCallbackType fromCode(String code) {
        return Stream.of(InvoiceResultCallbackType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
