package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * process_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
public enum ProcessStatus {

    _1("1", "待处理"),
    _2("2", "处理中"),
    _3("3", "处理完成"),
    _4("4", "无需处理"),
    _5("5", "处理失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProcessStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProcessStatus fromCode(String code) {
        return Stream.of(ProcessStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
