package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * release_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
public enum ReleaseType {

    _1("1", "释放预制发票"),
    _3("3", "不释放预制发票或业务单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReleaseType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReleaseType fromCode(String code) {
        return Stream.of(ReleaseType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
