package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * reverse_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
public enum ReverseStatus {

    _1("1", "未红冲"),
    _2("2", "红冲中"),
    _3("3", "红冲失败"),
    _4("4", "红冲成功");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReverseStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReverseStatus fromCode(String code) {
        return Stream.of(ReverseStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
