package com.xforceplus.ultraman.app.aliqianniu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * row_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-31
 */
public enum RowType {

    _0("0", "正常行"),
    _1("1", "折扣行"),
    _2("2", "被折扣行");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RowType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RowType fromCode(String code) {
        return Stream.of(RowType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
