package com.xforceplus.ultraman.app.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.InvoiceApplyDetail;
import com.xforceplus.ultraman.app.aliqianniu.service.IInvoiceApplyDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-05
 */
@RestController
public class InvoiceApplyDetailController {

  @Autowired
  private IInvoiceApplyDetailService invoiceApplyDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceApplyDetail ${table.comment}
   * @return
   */
  @GetMapping("/invoiceapplydetails" )
  public XfR getInvoiceApplyDetails(XfPage page, InvoiceApplyDetail invoiceApplyDetail) {
    return XfR.ok(invoiceApplyDetailServiceImpl.page(page, Wrappers.query(invoiceApplyDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceapplydetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceApplyDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceApplyDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoiceapplydetails")
  public XfR save(@RequestBody InvoiceApplyDetail invoiceApplyDetail) {
     return XfR.ok(invoiceApplyDetailServiceImpl.save(invoiceApplyDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceApplyDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoiceapplydetails/{id}")
  public XfR putUpdate(@RequestBody InvoiceApplyDetail invoiceApplyDetail,@PathVariable Long id) {
      invoiceApplyDetail.setId(id);
      return XfR.ok(invoiceApplyDetailServiceImpl.updateById(invoiceApplyDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceApplyDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoiceapplydetails/{id}")
  public XfR patchUpdate(@RequestBody InvoiceApplyDetail invoiceApplyDetail,@PathVariable Long id) {
      InvoiceApplyDetail upinvoiceApplyDetail = invoiceApplyDetailServiceImpl.getById(id);
      if(upinvoiceApplyDetail != null){
        upinvoiceApplyDetail = ObjectCopyUtils.copyProperties(invoiceApplyDetail,upinvoiceApplyDetail,true);
      }
      return XfR.ok(invoiceApplyDetailServiceImpl.updateById(upinvoiceApplyDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceapplydetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceApplyDetailServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceapplydetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_apply_detail");
     params.put("request", condition);

     return XfR.ok(invoiceApplyDetailServiceImpl.querys(params));
  }

}
