package com.xforceplus.ultraman.app.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.ResultInvoice;
import com.xforceplus.ultraman.app.aliqianniu.service.IResultInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 已开具发票前端控制器
 *
 * @author ultraman
 * @date 2023-06-05
 */
@RestController
public class ResultInvoiceController {

  @Autowired
  private IResultInvoiceService resultInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param resultInvoice 已开具发票
   * @return
   */
  @GetMapping("/resultinvoices" )
  public XfR getResultInvoices(XfPage page, ResultInvoice resultInvoice) {
    return XfR.ok(resultInvoiceServiceImpl.page(page, Wrappers.query(resultInvoice)));
  }

  /**
   * 通过id查询已开具发票
   * @param  id
   * @return XfR
   */
  @GetMapping("/resultinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(resultInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增已开具发票
   * @param resultInvoice 已开具发票
   * @return XfR
   */
  @PostMapping("/resultinvoices")
  public XfR save(@RequestBody ResultInvoice resultInvoice) {
     return XfR.ok(resultInvoiceServiceImpl.save(resultInvoice));
  }

  /**
   * 修改-传入修改后的全部数据已开具发票
   * @param resultInvoice 已开具发票
   * @return XfR
   */
  @PutMapping("/resultinvoices/{id}")
  public XfR putUpdate(@RequestBody ResultInvoice resultInvoice,@PathVariable Long id) {
      resultInvoice.setId(id);
      return XfR.ok(resultInvoiceServiceImpl.updateById(resultInvoice));
  }

  /**
   * 修改-传入修改的数据已开具发票
   * @param resultInvoice 已开具发票
   * @return XfR
   */
  @PatchMapping("/resultinvoices/{id}")
  public XfR patchUpdate(@RequestBody ResultInvoice resultInvoice,@PathVariable Long id) {
      ResultInvoice upresultInvoice = resultInvoiceServiceImpl.getById(id);
      if(upresultInvoice != null){
        upresultInvoice = ObjectCopyUtils.copyProperties(resultInvoice,upresultInvoice,true);
      }
      return XfR.ok(resultInvoiceServiceImpl.updateById(upresultInvoice));
  }

  /**
   * 通过id删除已开具发票
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/resultinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(resultInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/resultinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "result_invoice");
     params.put("request", condition);

     return XfR.ok(resultInvoiceServiceImpl.querys(params));
  }

}
