package com.xforceplus.ultraman.app.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.InvoiceApply;
import com.xforceplus.ultraman.app.aliqianniu.service.IInvoiceApplyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 开票申请前端控制器
 *
 * @author ultraman
 * @date 2023-08-31
 */
@RestController
public class InvoiceApplyController {

  @Autowired
  private IInvoiceApplyService invoiceApplyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceApply 开票申请
   * @return
   */
  @GetMapping("/invoiceapplys" )
  public XfR getInvoiceApplys(XfPage page, InvoiceApply invoiceApply) {
    return XfR.ok(invoiceApplyServiceImpl.page(page, Wrappers.query(invoiceApply)));
  }

  /**
   * 通过id查询开票申请
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceapplys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceApplyServiceImpl.getById(id));
  }

  /**
   * 新增开票申请
   * @param invoiceApply 开票申请
   * @return XfR
   */
  @PostMapping("/invoiceapplys")
  public XfR save(@RequestBody InvoiceApply invoiceApply) {
     return XfR.ok(invoiceApplyServiceImpl.save(invoiceApply));
  }

  /**
   * 修改-传入修改后的全部数据开票申请
   * @param invoiceApply 开票申请
   * @return XfR
   */
  @PutMapping("/invoiceapplys/{id}")
  public XfR putUpdate(@RequestBody InvoiceApply invoiceApply,@PathVariable Long id) {
      invoiceApply.setId(id);
      return XfR.ok(invoiceApplyServiceImpl.updateById(invoiceApply));
  }

  /**
   * 修改-传入修改的数据开票申请
   * @param invoiceApply 开票申请
   * @return XfR
   */
  @PatchMapping("/invoiceapplys/{id}")
  public XfR patchUpdate(@RequestBody InvoiceApply invoiceApply,@PathVariable Long id) {
      InvoiceApply upinvoiceApply = invoiceApplyServiceImpl.getById(id);
      if(upinvoiceApply != null){
        upinvoiceApply = ObjectCopyUtils.copyProperties(invoiceApply,upinvoiceApply,true);
      }
      return XfR.ok(invoiceApplyServiceImpl.updateById(upinvoiceApply));
  }

  /**
   * 通过id删除开票申请
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceapplys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceApplyServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceapplys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_apply");
     params.put("request", condition);

     return XfR.ok(invoiceApplyServiceImpl.querys(params));
  }

}
