package com.xforceplus.ultraman.app.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.OrderPaid;
import com.xforceplus.ultraman.app.aliqianniu.service.IOrderPaidService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 商户支付订单前端控制器
 *
 * @author ultraman
 * @date 2023-09-18
 */
@RestController
public class OrderPaidController {

  @Autowired
  private IOrderPaidService orderPaidServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderPaid 商户支付订单
   * @return
   */
  @GetMapping("/orderpaids" )
  public XfR getOrderPaids(XfPage page, OrderPaid orderPaid) {
    return XfR.ok(orderPaidServiceImpl.page(page, Wrappers.query(orderPaid)));
  }

  /**
   * 通过id查询商户支付订单
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderpaids/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderPaidServiceImpl.getById(id));
  }

  /**
   * 新增商户支付订单
   * @param orderPaid 商户支付订单
   * @return XfR
   */
  @PostMapping("/orderpaids")
  public XfR save(@RequestBody OrderPaid orderPaid) {
     return XfR.ok(orderPaidServiceImpl.save(orderPaid));
  }

  /**
   * 修改-传入修改后的全部数据商户支付订单
   * @param orderPaid 商户支付订单
   * @return XfR
   */
  @PutMapping("/orderpaids/{id}")
  public XfR putUpdate(@RequestBody OrderPaid orderPaid,@PathVariable Long id) {
      orderPaid.setId(id);
      return XfR.ok(orderPaidServiceImpl.updateById(orderPaid));
  }

  /**
   * 修改-传入修改的数据商户支付订单
   * @param orderPaid 商户支付订单
   * @return XfR
   */
  @PatchMapping("/orderpaids/{id}")
  public XfR patchUpdate(@RequestBody OrderPaid orderPaid,@PathVariable Long id) {
      OrderPaid uporderPaid = orderPaidServiceImpl.getById(id);
      if(uporderPaid != null){
        uporderPaid = ObjectCopyUtils.copyProperties(orderPaid,uporderPaid,true);
      }
      return XfR.ok(orderPaidServiceImpl.updateById(uporderPaid));
  }

  /**
   * 通过id删除商户支付订单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderpaids/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderPaidServiceImpl.removeById(id));
  }

  @PostMapping("/orderpaids/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_paid");
     params.put("request", condition);

     return XfR.ok(orderPaidServiceImpl.querys(params));
  }

}
