package com.xforceplus.ultraman.app.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.RpaAuthInfo;
import com.xforceplus.ultraman.app.aliqianniu.service.IRpaAuthInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-10-30
 */
@RestController
public class RpaAuthInfoController {

  @Autowired
  private IRpaAuthInfoService rpaAuthInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param rpaAuthInfo ${table.comment}
   * @return
   */
  @GetMapping("/rpaauthinfos" )
  public XfR getRpaAuthInfos(XfPage page, RpaAuthInfo rpaAuthInfo) {
    return XfR.ok(rpaAuthInfoServiceImpl.page(page, Wrappers.query(rpaAuthInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/rpaauthinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(rpaAuthInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param rpaAuthInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/rpaauthinfos")
  public XfR save(@RequestBody RpaAuthInfo rpaAuthInfo) {
     return XfR.ok(rpaAuthInfoServiceImpl.save(rpaAuthInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param rpaAuthInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/rpaauthinfos/{id}")
  public XfR putUpdate(@RequestBody RpaAuthInfo rpaAuthInfo,@PathVariable Long id) {
      rpaAuthInfo.setId(id);
      return XfR.ok(rpaAuthInfoServiceImpl.updateById(rpaAuthInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param rpaAuthInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/rpaauthinfos/{id}")
  public XfR patchUpdate(@RequestBody RpaAuthInfo rpaAuthInfo,@PathVariable Long id) {
      RpaAuthInfo uprpaAuthInfo = rpaAuthInfoServiceImpl.getById(id);
      if(uprpaAuthInfo != null){
        uprpaAuthInfo = ObjectCopyUtils.copyProperties(rpaAuthInfo,uprpaAuthInfo,true);
      }
      return XfR.ok(rpaAuthInfoServiceImpl.updateById(uprpaAuthInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/rpaauthinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(rpaAuthInfoServiceImpl.removeById(id));
  }

  @PostMapping("/rpaauthinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "rpa_auth_info");
     params.put("request", condition);

     return XfR.ok(rpaAuthInfoServiceImpl.querys(params));
  }

}
