package com.xforceplus.ultraman.app.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.FreightConfig;
import com.xforceplus.ultraman.app.aliqianniu.service.IFreightConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-04-29
 */
@RestController
public class FreightConfigController {

  @Autowired
  private IFreightConfigService freightConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param freightConfig ${table.comment}
   * @return
   */
  @GetMapping("/freightconfigs" )
  public XfR getFreightConfigs(XfPage page, FreightConfig freightConfig) {
    return XfR.ok(freightConfigServiceImpl.page(page, Wrappers.query(freightConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/freightconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(freightConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param freightConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/freightconfigs")
  public XfR save(@RequestBody FreightConfig freightConfig) {
     return XfR.ok(freightConfigServiceImpl.save(freightConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param freightConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/freightconfigs/{id}")
  public XfR putUpdate(@RequestBody FreightConfig freightConfig,@PathVariable Long id) {
      freightConfig.setId(id);
      return XfR.ok(freightConfigServiceImpl.updateById(freightConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param freightConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/freightconfigs/{id}")
  public XfR patchUpdate(@RequestBody FreightConfig freightConfig,@PathVariable Long id) {
      FreightConfig upfreightConfig = freightConfigServiceImpl.getById(id);
      if(upfreightConfig != null){
        upfreightConfig = ObjectCopyUtils.copyProperties(freightConfig,upfreightConfig,true);
      }
      return XfR.ok(freightConfigServiceImpl.updateById(upfreightConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/freightconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(freightConfigServiceImpl.removeById(id));
  }

  @PostMapping("/freightconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "freight_config");
     params.put("request", condition);

     return XfR.ok(freightConfigServiceImpl.querys(params));
  }

}
