package com.xforceplus.ultraman.app.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.ChannelSkuConfig;
import com.xforceplus.ultraman.app.aliqianniu.service.IChannelSkuConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-08-06
 */
@RestController
public class ChannelSkuConfigController {

  @Autowired
  private IChannelSkuConfigService channelSkuConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param channelSkuConfig ${table.comment}
   * @return
   */
  @GetMapping("/channelskuconfigs" )
  public XfR getChannelSkuConfigs(XfPage page, ChannelSkuConfig channelSkuConfig) {
    return XfR.ok(channelSkuConfigServiceImpl.page(page, Wrappers.query(channelSkuConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/channelskuconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(channelSkuConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param channelSkuConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/channelskuconfigs")
  public XfR save(@RequestBody ChannelSkuConfig channelSkuConfig) {
     return XfR.ok(channelSkuConfigServiceImpl.save(channelSkuConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param channelSkuConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/channelskuconfigs/{id}")
  public XfR putUpdate(@RequestBody ChannelSkuConfig channelSkuConfig,@PathVariable Long id) {
      channelSkuConfig.setId(id);
      return XfR.ok(channelSkuConfigServiceImpl.updateById(channelSkuConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param channelSkuConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/channelskuconfigs/{id}")
  public XfR patchUpdate(@RequestBody ChannelSkuConfig channelSkuConfig,@PathVariable Long id) {
      ChannelSkuConfig upchannelSkuConfig = channelSkuConfigServiceImpl.getById(id);
      if(upchannelSkuConfig != null){
        upchannelSkuConfig = ObjectCopyUtils.copyProperties(channelSkuConfig,upchannelSkuConfig,true);
      }
      return XfR.ok(channelSkuConfigServiceImpl.updateById(upchannelSkuConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/channelskuconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(channelSkuConfigServiceImpl.removeById(id));
  }

  @PostMapping("/channelskuconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "channel_sku_config");
     params.put("request", condition);

     return XfR.ok(channelSkuConfigServiceImpl.querys(params));
  }

}
