package com.xforceplus.ultraman.app.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.InvoicePerson;
import com.xforceplus.ultraman.app.aliqianniu.service.IInvoicePersonService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-08-06
 */
@RestController
public class InvoicePersonController {

  @Autowired
  private IInvoicePersonService invoicePersonServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoicePerson ${table.comment}
   * @return
   */
  @GetMapping("/invoicepersons" )
  public XfR getInvoicePersons(XfPage page, InvoicePerson invoicePerson) {
    return XfR.ok(invoicePersonServiceImpl.page(page, Wrappers.query(invoicePerson)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicepersons/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoicePersonServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoicePerson ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicepersons")
  public XfR save(@RequestBody InvoicePerson invoicePerson) {
     return XfR.ok(invoicePersonServiceImpl.save(invoicePerson));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoicePerson ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicepersons/{id}")
  public XfR putUpdate(@RequestBody InvoicePerson invoicePerson,@PathVariable Long id) {
      invoicePerson.setId(id);
      return XfR.ok(invoicePersonServiceImpl.updateById(invoicePerson));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoicePerson ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicepersons/{id}")
  public XfR patchUpdate(@RequestBody InvoicePerson invoicePerson,@PathVariable Long id) {
      InvoicePerson upinvoicePerson = invoicePersonServiceImpl.getById(id);
      if(upinvoicePerson != null){
        upinvoicePerson = ObjectCopyUtils.copyProperties(invoicePerson,upinvoicePerson,true);
      }
      return XfR.ok(invoicePersonServiceImpl.updateById(upinvoicePerson));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicepersons/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoicePersonServiceImpl.removeById(id));
  }

  @PostMapping("/invoicepersons/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_person");
     params.put("request", condition);

     return XfR.ok(invoicePersonServiceImpl.querys(params));
  }

}
