package com.xforceplus.ultraman.app.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.UnPushOrder;
import com.xforceplus.ultraman.app.aliqianniu.service.IUnPushOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-08-06
 */
@RestController
public class UnPushOrderController {

  @Autowired
  private IUnPushOrderService unPushOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param unPushOrder ${table.comment}
   * @return
   */
  @GetMapping("/unpushorders" )
  public XfR getUnPushOrders(XfPage page, UnPushOrder unPushOrder) {
    return XfR.ok(unPushOrderServiceImpl.page(page, Wrappers.query(unPushOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/unpushorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(unPushOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param unPushOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/unpushorders")
  public XfR save(@RequestBody UnPushOrder unPushOrder) {
     return XfR.ok(unPushOrderServiceImpl.save(unPushOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param unPushOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/unpushorders/{id}")
  public XfR putUpdate(@RequestBody UnPushOrder unPushOrder,@PathVariable Long id) {
      unPushOrder.setId(id);
      return XfR.ok(unPushOrderServiceImpl.updateById(unPushOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param unPushOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/unpushorders/{id}")
  public XfR patchUpdate(@RequestBody UnPushOrder unPushOrder,@PathVariable Long id) {
      UnPushOrder upunPushOrder = unPushOrderServiceImpl.getById(id);
      if(upunPushOrder != null){
        upunPushOrder = ObjectCopyUtils.copyProperties(unPushOrder,upunPushOrder,true);
      }
      return XfR.ok(unPushOrderServiceImpl.updateById(upunPushOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/unpushorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(unPushOrderServiceImpl.removeById(id));
  }

  @PostMapping("/unpushorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "un_push_order");
     params.put("request", condition);

     return XfR.ok(unPushOrderServiceImpl.querys(params));
  }

}
