package com.xforceplus.ultraman.app.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.CompanyConfig;
import com.xforceplus.ultraman.app.aliqianniu.service.ICompanyConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-04-22
 */
@RestController
public class CompanyConfigController {

  @Autowired
  private ICompanyConfigService companyConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param companyConfig ${table.comment}
   * @return
   */
  @GetMapping("/companyconfigs" )
  public XfR getCompanyConfigs(XfPage page, CompanyConfig companyConfig) {
    return XfR.ok(companyConfigServiceImpl.page(page, Wrappers.query(companyConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/companyconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(companyConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param companyConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/companyconfigs")
  public XfR save(@RequestBody CompanyConfig companyConfig) {
     return XfR.ok(companyConfigServiceImpl.save(companyConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param companyConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/companyconfigs/{id}")
  public XfR putUpdate(@RequestBody CompanyConfig companyConfig,@PathVariable Long id) {
      companyConfig.setId(id);
      return XfR.ok(companyConfigServiceImpl.updateById(companyConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param companyConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/companyconfigs/{id}")
  public XfR patchUpdate(@RequestBody CompanyConfig companyConfig,@PathVariable Long id) {
      CompanyConfig upcompanyConfig = companyConfigServiceImpl.getById(id);
      if(upcompanyConfig != null){
        upcompanyConfig = ObjectCopyUtils.copyProperties(companyConfig,upcompanyConfig,true);
      }
      return XfR.ok(companyConfigServiceImpl.updateById(upcompanyConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/companyconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(companyConfigServiceImpl.removeById(id));
  }

  @PostMapping("/companyconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "company_config");
     params.put("request", condition);

     return XfR.ok(companyConfigServiceImpl.querys(params));
  }

}
