package com.xforceplus.ultraman.app.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.DeliveryStore;
import com.xforceplus.ultraman.app.aliqianniu.service.IDeliveryStoreService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-16
 */
@RestController
public class DeliveryStoreController {

  @Autowired
  private IDeliveryStoreService deliveryStoreServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param deliveryStore ${table.comment}
   * @return
   */
  @GetMapping("/deliverystores" )
  public XfR getDeliveryStores(XfPage page, DeliveryStore deliveryStore) {
    return XfR.ok(deliveryStoreServiceImpl.page(page, Wrappers.query(deliveryStore)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/deliverystores/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(deliveryStoreServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param deliveryStore ${table.comment}
   * @return XfR
   */
  @PostMapping("/deliverystores")
  public XfR save(@RequestBody DeliveryStore deliveryStore) {
     return XfR.ok(deliveryStoreServiceImpl.save(deliveryStore));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param deliveryStore ${table.comment}
   * @return XfR
   */
  @PutMapping("/deliverystores/{id}")
  public XfR putUpdate(@RequestBody DeliveryStore deliveryStore,@PathVariable Long id) {
      deliveryStore.setId(id);
      return XfR.ok(deliveryStoreServiceImpl.updateById(deliveryStore));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param deliveryStore ${table.comment}
   * @return XfR
   */
  @PatchMapping("/deliverystores/{id}")
  public XfR patchUpdate(@RequestBody DeliveryStore deliveryStore,@PathVariable Long id) {
      DeliveryStore updeliveryStore = deliveryStoreServiceImpl.getById(id);
      if(updeliveryStore != null){
        updeliveryStore = ObjectCopyUtils.copyProperties(deliveryStore,updeliveryStore,true);
      }
      return XfR.ok(deliveryStoreServiceImpl.updateById(updeliveryStore));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/deliverystores/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(deliveryStoreServiceImpl.removeById(id));
  }

  @PostMapping("/deliverystores/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "delivery_store");
     params.put("request", condition);

     return XfR.ok(deliveryStoreServiceImpl.querys(params));
  }

}
