package com.xforceplus.ultraman.app.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.OrderSyncConfig;
import com.xforceplus.ultraman.app.aliqianniu.service.IOrderSyncConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-17
 */
@RestController
public class OrderSyncConfigController {

  @Autowired
  private IOrderSyncConfigService orderSyncConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderSyncConfig ${table.comment}
   * @return
   */
  @GetMapping("/ordersyncconfigs" )
  public XfR getOrderSyncConfigs(XfPage page, OrderSyncConfig orderSyncConfig) {
    return XfR.ok(orderSyncConfigServiceImpl.page(page, Wrappers.query(orderSyncConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordersyncconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderSyncConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderSyncConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordersyncconfigs")
  public XfR save(@RequestBody OrderSyncConfig orderSyncConfig) {
     return XfR.ok(orderSyncConfigServiceImpl.save(orderSyncConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderSyncConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordersyncconfigs/{id}")
  public XfR putUpdate(@RequestBody OrderSyncConfig orderSyncConfig,@PathVariable Long id) {
      orderSyncConfig.setId(id);
      return XfR.ok(orderSyncConfigServiceImpl.updateById(orderSyncConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderSyncConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordersyncconfigs/{id}")
  public XfR patchUpdate(@RequestBody OrderSyncConfig orderSyncConfig,@PathVariable Long id) {
      OrderSyncConfig uporderSyncConfig = orderSyncConfigServiceImpl.getById(id);
      if(uporderSyncConfig != null){
        uporderSyncConfig = ObjectCopyUtils.copyProperties(orderSyncConfig,uporderSyncConfig,true);
      }
      return XfR.ok(orderSyncConfigServiceImpl.updateById(uporderSyncConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordersyncconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderSyncConfigServiceImpl.removeById(id));
  }

  @PostMapping("/ordersyncconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_sync_config");
     params.put("request", condition);

     return XfR.ok(orderSyncConfigServiceImpl.querys(params));
  }

}
