package com.xforceplus.ultraman.app.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.InvoiceApplyInfo;
import com.xforceplus.ultraman.app.aliqianniu.service.IInvoiceApplyInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-20
 */
@RestController
public class InvoiceApplyInfoController {

  @Autowired
  private IInvoiceApplyInfoService invoiceApplyInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceApplyInfo ${table.comment}
   * @return
   */
  @GetMapping("/invoiceapplyinfos" )
  public XfR getInvoiceApplyInfos(XfPage page, InvoiceApplyInfo invoiceApplyInfo) {
    return XfR.ok(invoiceApplyInfoServiceImpl.page(page, Wrappers.query(invoiceApplyInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceapplyinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceApplyInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceApplyInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoiceapplyinfos")
  public XfR save(@RequestBody InvoiceApplyInfo invoiceApplyInfo) {
     return XfR.ok(invoiceApplyInfoServiceImpl.save(invoiceApplyInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceApplyInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoiceapplyinfos/{id}")
  public XfR putUpdate(@RequestBody InvoiceApplyInfo invoiceApplyInfo,@PathVariable Long id) {
      invoiceApplyInfo.setId(id);
      return XfR.ok(invoiceApplyInfoServiceImpl.updateById(invoiceApplyInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceApplyInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoiceapplyinfos/{id}")
  public XfR patchUpdate(@RequestBody InvoiceApplyInfo invoiceApplyInfo,@PathVariable Long id) {
      InvoiceApplyInfo upinvoiceApplyInfo = invoiceApplyInfoServiceImpl.getById(id);
      if(upinvoiceApplyInfo != null){
        upinvoiceApplyInfo = ObjectCopyUtils.copyProperties(invoiceApplyInfo,upinvoiceApplyInfo,true);
      }
      return XfR.ok(invoiceApplyInfoServiceImpl.updateById(upinvoiceApplyInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceapplyinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceApplyInfoServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceapplyinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_apply_info");
     params.put("request", condition);

     return XfR.ok(invoiceApplyInfoServiceImpl.querys(params));
  }

}
