package com.xforceplus.ultraman.app.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.TenantSellerConfig;
import com.xforceplus.ultraman.app.aliqianniu.service.ITenantSellerConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-20
 */
@RestController
public class TenantSellerConfigController {

  @Autowired
  private ITenantSellerConfigService tenantSellerConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tenantSellerConfig ${table.comment}
   * @return
   */
  @GetMapping("/tenantsellerconfigs" )
  public XfR getTenantSellerConfigs(XfPage page, TenantSellerConfig tenantSellerConfig) {
    return XfR.ok(tenantSellerConfigServiceImpl.page(page, Wrappers.query(tenantSellerConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tenantsellerconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tenantSellerConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tenantSellerConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/tenantsellerconfigs")
  public XfR save(@RequestBody TenantSellerConfig tenantSellerConfig) {
     return XfR.ok(tenantSellerConfigServiceImpl.save(tenantSellerConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tenantSellerConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/tenantsellerconfigs/{id}")
  public XfR putUpdate(@RequestBody TenantSellerConfig tenantSellerConfig,@PathVariable Long id) {
      tenantSellerConfig.setId(id);
      return XfR.ok(tenantSellerConfigServiceImpl.updateById(tenantSellerConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tenantSellerConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tenantsellerconfigs/{id}")
  public XfR patchUpdate(@RequestBody TenantSellerConfig tenantSellerConfig,@PathVariable Long id) {
      TenantSellerConfig uptenantSellerConfig = tenantSellerConfigServiceImpl.getById(id);
      if(uptenantSellerConfig != null){
        uptenantSellerConfig = ObjectCopyUtils.copyProperties(tenantSellerConfig,uptenantSellerConfig,true);
      }
      return XfR.ok(tenantSellerConfigServiceImpl.updateById(uptenantSellerConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tenantsellerconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tenantSellerConfigServiceImpl.removeById(id));
  }

  @PostMapping("/tenantsellerconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tenant_seller_config");
     params.put("request", condition);

     return XfR.ok(tenantSellerConfigServiceImpl.querys(params));
  }

}
