package com.xforceplus.ultraman.app.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.MessageBoards;
import com.xforceplus.ultraman.app.aliqianniu.service.IMessageBoardsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-21
 */
@RestController
public class MessageBoardsController {

  @Autowired
  private IMessageBoardsService messageBoardsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param messageBoards ${table.comment}
   * @return
   */
  @GetMapping("/messageboardss" )
  public XfR getMessageBoardss(XfPage page, MessageBoards messageBoards) {
    return XfR.ok(messageBoardsServiceImpl.page(page, Wrappers.query(messageBoards)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/messageboardss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(messageBoardsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param messageBoards ${table.comment}
   * @return XfR
   */
  @PostMapping("/messageboardss")
  public XfR save(@RequestBody MessageBoards messageBoards) {
     return XfR.ok(messageBoardsServiceImpl.save(messageBoards));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param messageBoards ${table.comment}
   * @return XfR
   */
  @PutMapping("/messageboardss/{id}")
  public XfR putUpdate(@RequestBody MessageBoards messageBoards,@PathVariable Long id) {
      messageBoards.setId(id);
      return XfR.ok(messageBoardsServiceImpl.updateById(messageBoards));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param messageBoards ${table.comment}
   * @return XfR
   */
  @PatchMapping("/messageboardss/{id}")
  public XfR patchUpdate(@RequestBody MessageBoards messageBoards,@PathVariable Long id) {
      MessageBoards upmessageBoards = messageBoardsServiceImpl.getById(id);
      if(upmessageBoards != null){
        upmessageBoards = ObjectCopyUtils.copyProperties(messageBoards,upmessageBoards,true);
      }
      return XfR.ok(messageBoardsServiceImpl.updateById(upmessageBoards));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/messageboardss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(messageBoardsServiceImpl.removeById(id));
  }

  @PostMapping("/messageboardss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "message_boards");
     params.put("request", condition);

     return XfR.ok(messageBoardsServiceImpl.querys(params));
  }

}
