package com.xforceplus.ultraman.app.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.StoreTax;
import com.xforceplus.ultraman.app.aliqianniu.service.IStoreTaxService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-31
 */
@RestController
public class StoreTaxController {

  @Autowired
  private IStoreTaxService storeTaxServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param storeTax ${table.comment}
   * @return
   */
  @GetMapping("/storetaxs" )
  public XfR getStoreTaxs(XfPage page, StoreTax storeTax) {
    return XfR.ok(storeTaxServiceImpl.page(page, Wrappers.query(storeTax)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/storetaxs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(storeTaxServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param storeTax ${table.comment}
   * @return XfR
   */
  @PostMapping("/storetaxs")
  public XfR save(@RequestBody StoreTax storeTax) {
     return XfR.ok(storeTaxServiceImpl.save(storeTax));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param storeTax ${table.comment}
   * @return XfR
   */
  @PutMapping("/storetaxs/{id}")
  public XfR putUpdate(@RequestBody StoreTax storeTax,@PathVariable Long id) {
      storeTax.setId(id);
      return XfR.ok(storeTaxServiceImpl.updateById(storeTax));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param storeTax ${table.comment}
   * @return XfR
   */
  @PatchMapping("/storetaxs/{id}")
  public XfR patchUpdate(@RequestBody StoreTax storeTax,@PathVariable Long id) {
      StoreTax upstoreTax = storeTaxServiceImpl.getById(id);
      if(upstoreTax != null){
        upstoreTax = ObjectCopyUtils.copyProperties(storeTax,upstoreTax,true);
      }
      return XfR.ok(storeTaxServiceImpl.updateById(upstoreTax));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/storetaxs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(storeTaxServiceImpl.removeById(id));
  }

  @PostMapping("/storetaxs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "store_tax");
     params.put("request", condition);

     return XfR.ok(storeTaxServiceImpl.querys(params));
  }

}
