package com.xforceplus.ultraman.app.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.AutoRetryTask;
import com.xforceplus.ultraman.app.aliqianniu.service.IAutoRetryTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-11-05
 */
@RestController
public class AutoRetryTaskController {

  @Autowired
  private IAutoRetryTaskService autoRetryTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param autoRetryTask ${table.comment}
   * @return
   */
  @GetMapping("/autoretrytasks" )
  public XfR getAutoRetryTasks(XfPage page, AutoRetryTask autoRetryTask) {
    return XfR.ok(autoRetryTaskServiceImpl.page(page, Wrappers.query(autoRetryTask)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/autoretrytasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(autoRetryTaskServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param autoRetryTask ${table.comment}
   * @return XfR
   */
  @PostMapping("/autoretrytasks")
  public XfR save(@RequestBody AutoRetryTask autoRetryTask) {
     return XfR.ok(autoRetryTaskServiceImpl.save(autoRetryTask));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param autoRetryTask ${table.comment}
   * @return XfR
   */
  @PutMapping("/autoretrytasks/{id}")
  public XfR putUpdate(@RequestBody AutoRetryTask autoRetryTask,@PathVariable Long id) {
      autoRetryTask.setId(id);
      return XfR.ok(autoRetryTaskServiceImpl.updateById(autoRetryTask));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param autoRetryTask ${table.comment}
   * @return XfR
   */
  @PatchMapping("/autoretrytasks/{id}")
  public XfR patchUpdate(@RequestBody AutoRetryTask autoRetryTask,@PathVariable Long id) {
      AutoRetryTask upautoRetryTask = autoRetryTaskServiceImpl.getById(id);
      if(upautoRetryTask != null){
        upautoRetryTask = ObjectCopyUtils.copyProperties(autoRetryTask,upautoRetryTask,true);
      }
      return XfR.ok(autoRetryTaskServiceImpl.updateById(upautoRetryTask));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/autoretrytasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(autoRetryTaskServiceImpl.removeById(id));
  }

  @PostMapping("/autoretrytasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "auto_retry_task");
     params.put("request", condition);

     return XfR.ok(autoRetryTaskServiceImpl.querys(params));
  }

}
