package com.xforceplus.ultraman.app.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.aliqianniu.entity.ChannelInfo;
import com.xforceplus.ultraman.app.aliqianniu.service.IChannelInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-11-05
 */
@RestController
public class ChannelInfoController {

  @Autowired
  private IChannelInfoService channelInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param channelInfo ${table.comment}
   * @return
   */
  @GetMapping("/channelinfos" )
  public XfR getChannelInfos(XfPage page, ChannelInfo channelInfo) {
    return XfR.ok(channelInfoServiceImpl.page(page, Wrappers.query(channelInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/channelinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(channelInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param channelInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/channelinfos")
  public XfR save(@RequestBody ChannelInfo channelInfo) {
     return XfR.ok(channelInfoServiceImpl.save(channelInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param channelInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/channelinfos/{id}")
  public XfR putUpdate(@RequestBody ChannelInfo channelInfo,@PathVariable Long id) {
      channelInfo.setId(id);
      return XfR.ok(channelInfoServiceImpl.updateById(channelInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param channelInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/channelinfos/{id}")
  public XfR patchUpdate(@RequestBody ChannelInfo channelInfo,@PathVariable Long id) {
      ChannelInfo upchannelInfo = channelInfoServiceImpl.getById(id);
      if(upchannelInfo != null){
        upchannelInfo = ObjectCopyUtils.copyProperties(channelInfo,upchannelInfo,true);
      }
      return XfR.ok(channelInfoServiceImpl.updateById(upchannelInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/channelinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(channelInfoServiceImpl.removeById(id));
  }

  @PostMapping("/channelinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "channel_info");
     params.put("request", condition);

     return XfR.ok(channelInfoServiceImpl.querys(params));
  }

}
