package com.xforceplus.ultraman.app.appomtest.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * om_bo
 * </p>
 *
 * @author ultraman
 * @since 2023-06-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OmBo implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * testFloat
   */
  private BigDecimal testFloat;
  /**
   * testBool
   */
  private Boolean testBool;
  /**
   * testTime
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime testTime;
  /**
   * testEnum
   */
  private String testEnum;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * mail
   */
  private String mail;
  /**
   * phone
   */
  private String phone;
  /**
   * 贫
   */
  private String dText;
  /**
   * 中
   */
  private String lText;
  /**
   * 富
   */
  private String rText;
  /**
   * testStr
   */
  private String testStr;
  /**
   * testInt
   */
  private Long testInt2;
  /**
   * ccc
   */
  private Boolean ccc;
  /**
   * dddd
   */
  private String ggggg;
  /**
   * xxxx
   */
  private String xxx;
  /**
   * www
   */
  private String ddww;
  /**
   * dddd
   */
  private String dddd;
  /**
   * dddd
   */
  private BigDecimal ddd;
  /**
   * ddd
   */
  private String ddxx;
  /**
   * strings
   */
  private String strings;
  /**
   * percentage
   */
  private BigDecimal percentage;
  /**
   * sdf
   */
  private String fs;
  /**
   * no
   */
  private Long no;
  /**
   * wankeField
   */
  private String wankeField;
  /**
   * omBoTenantField
   */
  private String omBoTenantField;
  /**
   * macdOmBoField
   */
  private String macdOmBoField;

  /**
   * 对一关联关系 关联对象 omBo
   */
  private Long gdsMTOId;
  /**
   * 对一关联关系 关联对象 hlj
   */
  private Long cccccId;
  /**
   * 对一关联关系 关联对象 null
   */
  private Long polyRelId;
  /**
   * 对一关联关系 关联对象 aBo
   */
  private Long nnnnnId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("testFloat", testFloat);
      map.put("testBool", testBool);
      map.put("testTime", BocpGenUtils.toTimestamp(testTime));
      map.put("testEnum", testEnum);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("mail", mail);
      map.put("phone", phone);
      map.put("d_text", dText);
      map.put("l_text", lText);
      map.put("r_text", rText);
      map.put("testStr", testStr);
      map.put("testInt2", testInt2);
      map.put("ccc", ccc);
      map.put("ggggg", ggggg);
      map.put("xxx", xxx);
      map.put("ddww", ddww);
      map.put("dddd", dddd);
      map.put("ddd", ddd);
      map.put("ddxx", ddxx);
      map.put("strings", strings);
      map.put("percentage", percentage);
      map.put("fs", fs);
      map.put("no", no);
      map.put("wankeField", wankeField);
      map.put("omBoTenantField", omBoTenantField);
      map.put("macdOmBoField", macdOmBoField);

      map.put("gdsMTO.id", gdsMTOId);
      map.put("ccccc.id", cccccId);
      map.put("polyRel.id", polyRelId);
      map.put("nnnnn.id", nnnnnId);
      return map;
  }

  public static OmBo fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    OmBo entity = new OmBo();

    if(map.containsKey("testFloat")) {
      Object obj = map.get("testFloat");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTestFloat((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTestFloat(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTestFloat(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTestFloat(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTestFloat(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("testBool")) {
      Object obj = map.get("testBool");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setTestBool((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTestBool(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("testTime")) {
      Object obj = map.get("testTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTestTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTestTime(null);
      }
    }
    if(map.containsKey("testEnum")) {
      Object obj = map.get("testEnum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTestEnum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mail")) {
      Object obj = map.get("mail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("phone")) {
      Object obj = map.get("phone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("d_text")) {
      Object obj = map.get("d_text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("l_text")) {
      Object obj = map.get("l_text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("r_text")) {
      Object obj = map.get("r_text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("testStr")) {
      Object obj = map.get("testStr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTestStr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("testInt2")) {
      Object obj = map.get("testInt2");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTestInt2((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTestInt2(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTestInt2(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ccc")) {
      Object obj = map.get("ccc");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setCcc((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCcc(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("ggggg")) {
      Object obj = map.get("ggggg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGgggg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xxx")) {
      Object obj = map.get("xxx");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXxx((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ddww")) {
      Object obj = map.get("ddww");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDdww((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dddd")) {
      Object obj = map.get("dddd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDddd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ddd")) {
      Object obj = map.get("ddd");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDdd((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDdd(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDdd(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDdd(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDdd(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ddxx")) {
      Object obj = map.get("ddxx");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDdxx((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("strings")) {
      Object obj = map.get("strings");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStrings((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("percentage")) {
      Object obj = map.get("percentage");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPercentage((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPercentage(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPercentage(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPercentage(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPercentage(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("fs")) {
      Object obj = map.get("fs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("no")) {
      Object obj = map.get("no");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("wankeField")) {
      Object obj = map.get("wankeField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWankeField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("omBoTenantField")) {
      Object obj = map.get("omBoTenantField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOmBoTenantField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("macdOmBoField")) {
      Object obj = map.get("macdOmBoField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMacdOmBoField((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("gdsMTO.id")) {
       Object obj = map.get("gdsMTO.id");
       if(obj instanceof Long) {
         entity.setGdsMTOId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setGdsMTOId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("ccccc.id")) {
       Object obj = map.get("ccccc.id");
       if(obj instanceof Long) {
         entity.setCccccId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setCccccId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("polyRel.id")) {
       Object obj = map.get("polyRel.id");
       if(obj instanceof Long) {
         entity.setPolyRelId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setPolyRelId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("nnnnn.id")) {
       Object obj = map.get("nnnnn.id");
       if(obj instanceof Long) {
         entity.setNnnnnId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setNnnnnId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("testFloat")) {
      Object obj = map.get("testFloat");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTestFloat((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTestFloat(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTestFloat(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTestFloat(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTestFloat(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("testBool")) {
      Object obj = map.get("testBool");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setTestBool((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTestBool(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("testTime")) {
      Object obj = map.get("testTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setTestTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setTestTime(null);
      }
    }
    if(map.containsKey("testEnum")) {
      Object obj = map.get("testEnum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTestEnum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mail")) {
      Object obj = map.get("mail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("phone")) {
      Object obj = map.get("phone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("d_text")) {
      Object obj = map.get("d_text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("l_text")) {
      Object obj = map.get("l_text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("r_text")) {
      Object obj = map.get("r_text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("testStr")) {
      Object obj = map.get("testStr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTestStr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("testInt2")) {
      Object obj = map.get("testInt2");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTestInt2((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTestInt2(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTestInt2(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ccc")) {
      Object obj = map.get("ccc");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setCcc((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCcc(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("ggggg")) {
      Object obj = map.get("ggggg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGgggg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xxx")) {
      Object obj = map.get("xxx");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setXxx((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ddww")) {
      Object obj = map.get("ddww");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDdww((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dddd")) {
      Object obj = map.get("dddd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDddd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ddd")) {
      Object obj = map.get("ddd");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDdd((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDdd(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDdd(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDdd(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDdd(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ddxx")) {
      Object obj = map.get("ddxx");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDdxx((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("strings")) {
      Object obj = map.get("strings");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStrings((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("percentage")) {
      Object obj = map.get("percentage");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPercentage((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPercentage(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPercentage(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPercentage(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPercentage(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("fs")) {
      Object obj = map.get("fs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("no")) {
      Object obj = map.get("no");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("wankeField")) {
      Object obj = map.get("wankeField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWankeField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("omBoTenantField")) {
      Object obj = map.get("omBoTenantField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOmBoTenantField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("macdOmBoField")) {
      Object obj = map.get("macdOmBoField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMacdOmBoField((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("gdsMTO.id")) {
    Object obj = map.get("gdsMTO.id");
    if(obj instanceof Long) {
        this.setGdsMTOId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setGdsMTOId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("ccccc.id")) {
    Object obj = map.get("ccccc.id");
    if(obj instanceof Long) {
        this.setCccccId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setCccccId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("polyRel.id")) {
    Object obj = map.get("polyRel.id");
    if(obj instanceof Long) {
        this.setPolyRelId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setPolyRelId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("nnnnn.id")) {
    Object obj = map.get("nnnnn.id");
    if(obj instanceof Long) {
        this.setNnnnnId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setNnnnnId(Long.parseLong((String)obj));
    }
  }
  }
}
