package com.xforceplus.ultraman.app.appomtest.metadata.validator;

import com.xforceplus.ultraman.app.appomtest.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.appomtest.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-06-14
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(TestDict.class)) {
            isValid = null != TestDict.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TestDict.class.getSimpleName());
            }
        }
        if(clazz.equals(Sdf.class)) {
            isValid = null != Sdf.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Sdf.class.getSimpleName());
            }
        }
        if(clazz.equals(Hikujjh.class)) {
            isValid = null != Hikujjh.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Hikujjh.class.getSimpleName());
            }
        }
        if(clazz.equals(Meijuxing0001.class)) {
            isValid = null != Meijuxing0001.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Meijuxing0001.class.getSimpleName());
            }
        }
        if(clazz.equals(Sdfsdfsdf.class)) {
            isValid = null != Sdfsdfsdf.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Sdfsdfsdf.class.getSimpleName());
            }
        }
        if(clazz.equals(Jghjghjghj.class)) {
            isValid = null != Jghjghjghj.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Jghjghjghj.class.getSimpleName());
            }
        }
        if(clazz.equals(Fgsg.class)) {
            isValid = null != Fgsg.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Fgsg.class.getSimpleName());
            }
        }
        if(clazz.equals(Sdfgfdf.class)) {
            isValid = null != Sdfgfdf.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Sdfgfdf.class.getSimpleName());
            }
        }
        if(clazz.equals(Ghj.class)) {
            isValid = null != Ghj.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Ghj.class.getSimpleName());
            }
        }
        if(clazz.equals(Fdgdgf.class)) {
            isValid = null != Fdgdgf.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Fdgdgf.class.getSimpleName());
            }
        }
        if(clazz.equals(Xcvv.class)) {
            isValid = null != Xcvv.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Xcvv.class.getSimpleName());
            }
        }
        if(clazz.equals(Gdf.class)) {
            isValid = null != Gdf.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Gdf.class.getSimpleName());
            }
        }
        if(clazz.equals(Sdfdg.class)) {
            isValid = null != Sdfdg.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Sdfdg.class.getSimpleName());
            }
        }
        if(clazz.equals(Sdffgfgdfg.class)) {
            isValid = null != Sdffgfgdfg.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Sdffgfgdfg.class.getSimpleName());
            }
        }
        if(clazz.equals(Dgghj.class)) {
            isValid = null != Dgghj.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Dgghj.class.getSimpleName());
            }
        }
        if(clazz.equals(Dfsdf.class)) {
            isValid = null != Dfsdf.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Dfsdf.class.getSimpleName());
            }
        }
        if(clazz.equals(Xvzzvzv.class)) {
            isValid = null != Xvzzvzv.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Xvzzvzv.class.getSimpleName());
            }
        }
        if(clazz.equals(Eqwew.class)) {
            isValid = null != Eqwew.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Eqwew.class.getSimpleName());
            }
        }
        if(clazz.equals(Dsfsdfs.class)) {
            isValid = null != Dsfsdfs.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Dsfsdfs.class.getSimpleName());
            }
        }
        if(clazz.equals(Fsfsd.class)) {
            isValid = null != Fsfsd.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Fsfsd.class.getSimpleName());
            }
        }
        if(clazz.equals(Gjghjghj.class)) {
            isValid = null != Gjghjghj.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Gjghjghj.class.getSimpleName());
            }
        }
        if(clazz.equals(Kjh.class)) {
            isValid = null != Kjh.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Kjh.class.getSimpleName());
            }
        }
        if(clazz.equals(Fghhg.class)) {
            isValid = null != Fghhg.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Fghhg.class.getSimpleName());
            }
        }
        if(clazz.equals(Dfgds.class)) {
            isValid = null != Dfgds.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Dfgds.class.getSimpleName());
            }
        }
        if(clazz.equals(Ewrwe.class)) {
            isValid = null != Ewrwe.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Ewrwe.class.getSimpleName());
            }
        }
        if(clazz.equals(Sdfsdfwe.class)) {
            isValid = null != Sdfsdfwe.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Sdfsdfwe.class.getSimpleName());
            }
        }
        if(clazz.equals(Sx.class)) {
            isValid = null != Sx.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Sx.class.getSimpleName());
            }
        }
        if(clazz.equals(Fsgf.class)) {
            isValid = null != Fsgf.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Fsgf.class.getSimpleName());
            }
        }
        if(clazz.equals(Cxvzvc.class)) {
            isValid = null != Cxvzvc.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Cxvzvc.class.getSimpleName());
            }
        }
        if(clazz.equals(Vcb.class)) {
            isValid = null != Vcb.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Vcb.class.getSimpleName());
            }
        }
        if(clazz.equals(Sdfsdfsdsdfsdf.class)) {
            isValid = null != Sdfsdfsdsdfsdf.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Sdfsdfsdsdfsdf.class.getSimpleName());
            }
        }
        if(clazz.equals(Sdfsdfswqdf.class)) {
            isValid = null != Sdfsdfswqdf.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Sdfsdfswqdf.class.getSimpleName());
            }
        }
        if(clazz.equals(Fdg.class)) {
            isValid = null != Fdg.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Fdg.class.getSimpleName());
            }
        }
        if(clazz.equals(Dsfsdfsdf.class)) {
            isValid = null != Dsfsdfsdf.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Dsfsdfsdf.class.getSimpleName());
            }
        }
        if(clazz.equals(Fhkii.class)) {
            isValid = null != Fhkii.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Fhkii.class.getSimpleName());
            }
        }
        if(clazz.equals(Fs.class)) {
            isValid = null != Fs.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Fs.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
