package com.xforceplus.ultraman.app.appomtest.metadata.validator;

import com.xforceplus.ultraman.app.appomtest.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.appomtest.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-06-14
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(TestDict.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TestDict.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TestDict.class.getSimpleName());
            }
        }
        if(clazz.equals(Sdf.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Sdf.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Sdf.class.getSimpleName());
            }
        }
        if(clazz.equals(Hikujjh.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Hikujjh.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Hikujjh.class.getSimpleName());
            }
        }
        if(clazz.equals(Meijuxing0001.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Meijuxing0001.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Meijuxing0001.class.getSimpleName());
            }
        }
        if(clazz.equals(Sdfsdfsdf.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Sdfsdfsdf.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Sdfsdfsdf.class.getSimpleName());
            }
        }
        if(clazz.equals(Jghjghjghj.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Jghjghjghj.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Jghjghjghj.class.getSimpleName());
            }
        }
        if(clazz.equals(Fgsg.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Fgsg.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Fgsg.class.getSimpleName());
            }
        }
        if(clazz.equals(Sdfgfdf.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Sdfgfdf.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Sdfgfdf.class.getSimpleName());
            }
        }
        if(clazz.equals(Ghj.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Ghj.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Ghj.class.getSimpleName());
            }
        }
        if(clazz.equals(Fdgdgf.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Fdgdgf.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Fdgdgf.class.getSimpleName());
            }
        }
        if(clazz.equals(Xcvv.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Xcvv.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Xcvv.class.getSimpleName());
            }
        }
        if(clazz.equals(Gdf.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Gdf.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Gdf.class.getSimpleName());
            }
        }
        if(clazz.equals(Sdfdg.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Sdfdg.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Sdfdg.class.getSimpleName());
            }
        }
        if(clazz.equals(Sdffgfgdfg.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Sdffgfgdfg.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Sdffgfgdfg.class.getSimpleName());
            }
        }
        if(clazz.equals(Dgghj.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Dgghj.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Dgghj.class.getSimpleName());
            }
        }
        if(clazz.equals(Dfsdf.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Dfsdf.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Dfsdf.class.getSimpleName());
            }
        }
        if(clazz.equals(Xvzzvzv.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Xvzzvzv.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Xvzzvzv.class.getSimpleName());
            }
        }
        if(clazz.equals(Eqwew.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Eqwew.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Eqwew.class.getSimpleName());
            }
        }
        if(clazz.equals(Dsfsdfs.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Dsfsdfs.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Dsfsdfs.class.getSimpleName());
            }
        }
        if(clazz.equals(Fsfsd.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Fsfsd.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Fsfsd.class.getSimpleName());
            }
        }
        if(clazz.equals(Gjghjghj.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Gjghjghj.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Gjghjghj.class.getSimpleName());
            }
        }
        if(clazz.equals(Kjh.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Kjh.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Kjh.class.getSimpleName());
            }
        }
        if(clazz.equals(Fghhg.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Fghhg.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Fghhg.class.getSimpleName());
            }
        }
        if(clazz.equals(Dfgds.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Dfgds.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Dfgds.class.getSimpleName());
            }
        }
        if(clazz.equals(Ewrwe.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Ewrwe.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Ewrwe.class.getSimpleName());
            }
        }
        if(clazz.equals(Sdfsdfwe.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Sdfsdfwe.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Sdfsdfwe.class.getSimpleName());
            }
        }
        if(clazz.equals(Sx.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Sx.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Sx.class.getSimpleName());
            }
        }
        if(clazz.equals(Fsgf.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Fsgf.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Fsgf.class.getSimpleName());
            }
        }
        if(clazz.equals(Cxvzvc.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Cxvzvc.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Cxvzvc.class.getSimpleName());
            }
        }
        if(clazz.equals(Vcb.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Vcb.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Vcb.class.getSimpleName());
            }
        }
        if(clazz.equals(Sdfsdfsdsdfsdf.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Sdfsdfsdsdfsdf.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Sdfsdfsdsdfsdf.class.getSimpleName());
            }
        }
        if(clazz.equals(Sdfsdfswqdf.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Sdfsdfswqdf.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Sdfsdfswqdf.class.getSimpleName());
            }
        }
        if(clazz.equals(Fdg.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Fdg.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Fdg.class.getSimpleName());
            }
        }
        if(clazz.equals(Dsfsdfsdf.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Dsfsdfsdf.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Dsfsdfsdf.class.getSimpleName());
            }
        }
        if(clazz.equals(Fhkii.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Fhkii.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Fhkii.class.getSimpleName());
            }
        }
        if(clazz.equals(Fs.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Fs.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Fs.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
