package com.xforceplus.ultraman.app.arterydocument.controller;


/**
 * 弃用feign客户端
 *
 * @author ultraman
 * @date 2024-05-08
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.PosBackTracking;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "artery-document")
public interface PosBackTrackingFeignApi {

  /**
   * 通过id查询弃用
   * @param  id
   * @return R
   */
  @GetMapping("/posBackTracking/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增弃用
   * @param posBackTracking 弃用
   * @return R
   */
  @PostMapping("/posBackTracking/add")
  public R save(@RequestBody PosBackTracking posBackTracking);

  /**
   * 修改弃用
   * @param posBackTracking 弃用
   * @return R
   */
  @PostMapping("/posBackTracking/update")
  public R updateById(@RequestBody PosBackTracking posBackTracking);

  /**
   * 通过id删除弃用
   * @param  id
   * @return R
   */
  @DeleteMapping("/posBackTracking/del/{id}" )
  public R removeById(@PathVariable Long id);

}