package com.xforceplus.ultraman.app.arterydocument.controller;


/**
 * V2feign客户端
 *
 * @author ultraman
 * @date 2024-05-08
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.SettlementDocGRNRTVDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "artery-document")
public interface SettlementDocGRNRTVDetailFeignApi {

  /**
   * 通过id查询V2
   * @param  id
   * @return R
   */
  @GetMapping("/settlementDocGRNRTVDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增V2
   * @param settlementDocGRNRTVDetail V2
   * @return R
   */
  @PostMapping("/settlementDocGRNRTVDetail/add")
  public R save(@RequestBody SettlementDocGRNRTVDetail settlementDocGRNRTVDetail);

  /**
   * 修改V2
   * @param settlementDocGRNRTVDetail V2
   * @return R
   */
  @PostMapping("/settlementDocGRNRTVDetail/update")
  public R updateById(@RequestBody SettlementDocGRNRTVDetail settlementDocGRNRTVDetail);

  /**
   * 通过id删除V2
   * @param  id
   * @return R
   */
  @DeleteMapping("/settlementDocGRNRTVDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}