package com.xforceplus.ultraman.app.arterydocument.controller;


/**
 * 送货预约明细feign客户端
 *
 * @author ultraman
 * @date 2024-05-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.ReservationDeliveryNoteDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "artery-document")
public interface ReservationDeliveryNoteDetailFeignApi {

  /**
   * 通过id查询送货预约明细
   * @param  id
   * @return R
   */
  @GetMapping("/reservationDeliveryNoteDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增送货预约明细
   * @param reservationDeliveryNoteDetail 送货预约明细
   * @return R
   */
  @PostMapping("/reservationDeliveryNoteDetail/add")
  public R save(@RequestBody ReservationDeliveryNoteDetail reservationDeliveryNoteDetail);

  /**
   * 修改送货预约明细
   * @param reservationDeliveryNoteDetail 送货预约明细
   * @return R
   */
  @PostMapping("/reservationDeliveryNoteDetail/update")
  public R updateById(@RequestBody ReservationDeliveryNoteDetail reservationDeliveryNoteDetail);

  /**
   * 通过id删除送货预约明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/reservationDeliveryNoteDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}