package com.xforceplus.ultraman.app.arterydocument.controller;


/**
 * 商超回写选项feign客户端
 *
 * @author ultraman
 * @date 2024-06-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.SupermarketWritebackOptions;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "artery-document")
public interface SupermarketWritebackOptionsFeignApi {

  /**
   * 通过id查询商超回写选项
   * @param  id
   * @return R
   */
  @GetMapping("/supermarketWritebackOptions/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增商超回写选项
   * @param supermarketWritebackOptions 商超回写选项
   * @return R
   */
  @PostMapping("/supermarketWritebackOptions/add")
  public R save(@RequestBody SupermarketWritebackOptions supermarketWritebackOptions);

  /**
   * 修改商超回写选项
   * @param supermarketWritebackOptions 商超回写选项
   * @return R
   */
  @PostMapping("/supermarketWritebackOptions/update")
  public R updateById(@RequestBody SupermarketWritebackOptions supermarketWritebackOptions);

  /**
   * 通过id删除商超回写选项
   * @param  id
   * @return R
   */
  @DeleteMapping("/supermarketWritebackOptions/del/{id}" )
  public R removeById(@PathVariable Long id);

}