package com.xforceplus.ultraman.app.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-03-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ExpenseSettlementDetail implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 序号
   */
  @TableField("lineNo")
  private String lineNo;

  /**
   * 费用单号
   */
  @TableField("expenseDocumentNo")
  private String expenseDocumentNo;

  /**
   * 区域编码
   */
  @TableField("regionCode")
  private String regionCode;

  /**
   * 区域名称
   */
  @TableField("regionName")
  private String regionName;

  /**
   * 门店编码
   */
  @TableField("purchaseStoreCode")
  private String purchaseStoreCode;

  /**
   * 门店GLN
   */
  @TableField("purchaseStoreGLN")
  private String purchaseStoreGLN;

  /**
   * 门店名称
   */
  @TableField("purchaseStoreName")
  private String purchaseStoreName;

  /**
   * 费用单类型
   */
  @TableField("documentType")
  private String documentType;

  /**
   * 费用单类型名称
   */
  @TableField("documentTypeName")
  private String documentTypeName;

  /**
   * 账扣票扣类型
   */
  @TableField("deductionType")
  private String deductionType;

  /**
   * 税率类型
   */
  @TableField("taxType")
  private String taxType;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 费用代码
   */
  @TableField("expenseType")
  private String expenseType;

  /**
   * 费用名称
   */
  @TableField("expenseName")
  private String expenseName;

  /**
   * 费用金额（含税）
   */
  @TableField("expenseAmtWithTax")
  private BigDecimal expenseAmtWithTax;

  /**
   * 费用金额（不含税）
   */
  @TableField("expenseAmtWithoutTax")
  private BigDecimal expenseAmtWithoutTax;

  /**
   * 费用说明
   */
  @TableField("expenseDesc")
  private String expenseDesc;

  /**
   * 业务发生日期
   */
  @TableField("businessOccurrenceDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime businessOccurrenceDate;

  /**
   * 结算日期
   */
  @TableField("settlementDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementDate;

  /**
   * 合同号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 结算单子单号
   */
  @TableField("settlementSubNo")
  private String settlementSubNo;

  /**
   * 手工单号
   */
  @TableField("manualDocumentNo")
  private String manualDocumentNo;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("lineNo", lineNo);
      map.put("expenseDocumentNo", expenseDocumentNo);
      map.put("regionCode", regionCode);
      map.put("regionName", regionName);
      map.put("purchaseStoreCode", purchaseStoreCode);
      map.put("purchaseStoreGLN", purchaseStoreGLN);
      map.put("purchaseStoreName", purchaseStoreName);
      map.put("documentType", documentType);
      map.put("documentTypeName", documentTypeName);
      map.put("deductionType", deductionType);
      map.put("taxType", taxType);
      map.put("taxRate", taxRate);
      map.put("expenseType", expenseType);
      map.put("expenseName", expenseName);
      map.put("expenseAmtWithTax", expenseAmtWithTax);
      map.put("expenseAmtWithoutTax", expenseAmtWithoutTax);
      map.put("expenseDesc", expenseDesc);
      map.put("businessOccurrenceDate", BocpGenUtils.toTimestamp(businessOccurrenceDate));
      map.put("settlementDate", BocpGenUtils.toTimestamp(settlementDate));
      map.put("contractNo", contractNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("settlementSubNo", settlementSubNo);
      map.put("manualDocumentNo", manualDocumentNo);
      return map;
  }

  public static ExpenseSettlementDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ExpenseSettlementDetail entity = new ExpenseSettlementDetail();
    if(map.containsKey("lineNo")) {
      Object obj = map.get("lineNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expenseDocumentNo")) {
      Object obj = map.get("expenseDocumentNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExpenseDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentTypeName")) {
      Object obj = map.get("documentTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDocumentTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deductionType")) {
      Object obj = map.get("deductionType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeductionType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxType")) {
      Object obj = map.get("taxType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("expenseType")) {
      Object obj = map.get("expenseType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExpenseType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expenseName")) {
      Object obj = map.get("expenseName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExpenseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expenseAmtWithTax")) {
      Object obj = map.get("expenseAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExpenseAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExpenseAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExpenseAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setExpenseAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExpenseAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("expenseAmtWithoutTax")) {
      Object obj = map.get("expenseAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExpenseAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExpenseAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExpenseAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setExpenseAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExpenseAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("expenseDesc")) {
      Object obj = map.get("expenseDesc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExpenseDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessOccurrenceDate")) {
      Object obj = map.get("businessOccurrenceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessOccurrenceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBusinessOccurrenceDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setBusinessOccurrenceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBusinessOccurrenceDate(null);
      }
    }
    if(map.containsKey("settlementDate")) {
      Object obj = map.get("settlementDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSettlementDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSettlementDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementDate(null);
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementSubNo")) {
      Object obj = map.get("settlementSubNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementSubNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manualDocumentNo")) {
      Object obj = map.get("manualDocumentNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setManualDocumentNo((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("lineNo")) {
      Object obj = map.get("lineNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expenseDocumentNo")) {
      Object obj = map.get("expenseDocumentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpenseDocumentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreGLN((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentTypeName")) {
      Object obj = map.get("documentTypeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deductionType")) {
      Object obj = map.get("deductionType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeductionType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxType")) {
      Object obj = map.get("taxType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("expenseType")) {
      Object obj = map.get("expenseType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpenseType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expenseName")) {
      Object obj = map.get("expenseName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpenseName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expenseAmtWithTax")) {
      Object obj = map.get("expenseAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setExpenseAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setExpenseAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setExpenseAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setExpenseAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setExpenseAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("expenseAmtWithoutTax")) {
      Object obj = map.get("expenseAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setExpenseAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setExpenseAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setExpenseAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setExpenseAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setExpenseAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("expenseDesc")) {
      Object obj = map.get("expenseDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpenseDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessOccurrenceDate")) {
      Object obj = map.get("businessOccurrenceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBusinessOccurrenceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBusinessOccurrenceDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setBusinessOccurrenceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBusinessOccurrenceDate(null);
      }
    }
    if(map.containsKey("settlementDate")) {
      Object obj = map.get("settlementDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSettlementDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSettlementDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setSettlementDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSettlementDate(null);
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementSubNo")) {
      Object obj = map.get("settlementSubNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementSubNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("manualDocumentNo")) {
      Object obj = map.get("manualDocumentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setManualDocumentNo((String)obj);
        }
      } else {
      }
    }
  }
}
