package com.xforceplus.ultraman.app.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-03-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Inventory implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 是否是最新版本
   */
  private Boolean latest;

  /**
   * 原始单据Id数组
   */
  private String srcids;

  /**
   * 所属租户
   */
  @TableField("belongTenant")
  private String belongTenant;

  /**
   * 商超账号
   */
  @TableField("collectionAccount")
  private String collectionAccount;

  /**
   * 采集批次
   */
  @TableField("collectionBatch")
  private String collectionBatch;

  /**
   * 采集日期
   */
  @TableField("collectionDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime collectionDate;

  /**
   * 购方统一社会信用代码
   */
  @TableField("purchaseCompanyTaxNo")
  private String purchaseCompanyTaxNo;

  /**
   * 零售商编码
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 零售商描述
   */
  @TableField("purchaseRetailerName")
  private String purchaseRetailerName;

  /**
   * 购方公司编码
   */
  @TableField("purchaseCompanyCode")
  private String purchaseCompanyCode;

  /**
   * 购方公司名称
   */
  @TableField("purchaseCompanyName")
  private String purchaseCompanyName;

  /**
   * 区域编码
   */
  @TableField("regionCode")
  private String regionCode;

  /**
   * 区域名称
   */
  @TableField("regionName")
  private String regionName;

  /**
   * 购方门店编码
   */
  @TableField("purchaseStoreCode")
  private String purchaseStoreCode;

  /**
   * 购方门店GLN
   */
  @TableField("purchaseStoreGLN")
  private String purchaseStoreGLN;

  /**
   * 购方门店名称
   */
  @TableField("purchaseStoreName")
  private String purchaseStoreName;

  /**
   * 大仓编码
   */
  @TableField("purchaseStorageCenterCode")
  private String purchaseStorageCenterCode;

  /**
   * 大仓名称
   */
  @TableField("purchaseStorageCenterName")
  private String purchaseStorageCenterName;

  /**
   * 品类编码
   */
  @TableField("categoryCode")
  private String categoryCode;

  /**
   * 品类名称
   */
  @TableField("categoryName")
  private String categoryName;

  /**
   * 销方编码
   */
  @TableField("sellerCode")
  private String sellerCode;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 商品编码
   */
  @TableField("itemCode")
  private String itemCode;

  /**
   * 商品条码
   */
  private String barcode;

  /**
   * 商品子编码
   */
  @TableField("itemSubCode")
  private String itemSubCode;

  /**
   * 商品名称
   */
  @TableField("itemDesc")
  private String itemDesc;

  /**
   * 品牌
   */
  private String brand;

  /**
   * 规格
   */
  private String standards;

  /**
   * 型号
   */
  private String model;

  /**
   * 商品状态
   */
  @TableField("itemStatus")
  private BigDecimal itemStatus;

  /**
   * 基本单位
   */
  private String unit;

  /**
   * 期间类型
   */
  @TableField("sectionType")
  private String sectionType;

  /**
   * 年/月/日
   */
  @TableField("sectionDate")
  private String sectionDate;

  /**
   * 进货数量
   */
  @TableField("purchaseQty")
  private String purchaseQty;

  /**
   * 进货金额
   */
  @TableField("purchaseAmt")
  private BigDecimal purchaseAmt;

  /**
   * 年/月/日均进货量
   */
  @TableField("averagePurchaseAmt")
  private BigDecimal averagePurchaseAmt;

  /**
   * 销售数量
   */
  @TableField("salesQty")
  private BigDecimal salesQty;

  /**
   * 销售金额
   */
  @TableField("saleAmt")
  private BigDecimal saleAmt;

  /**
   * 年/月/日均销售量
   */
  @TableField("averageSaleQty")
  private BigDecimal averageSaleQty;

  /**
   * 库存日期
   */
  @TableField("stockDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime stockDate;

  /**
   * 库存余额数量
   */
  @TableField("stockQty")
  private BigDecimal stockQty;

  /**
   * 库存余额金额
   */
  @TableField("stockAmt")
  private BigDecimal stockAmt;

  /**
   * 在途数量
   */
  @TableField("transitQty")
  private BigDecimal transitQty;

  /**
   * 在途金额
   */
  @TableField("transitAmt")
  private BigDecimal transitAmt;

  /**
   * 备注
   */
  private String remark;

  /**
   * 扩展字段_字符串_1
   */
  private String extstr1;

  /**
   * 扩展字段_字符串_2
   */
  private String extstr2;

  /**
   * 扩展字段_字符串_3
   */
  private String extstr3;

  /**
   * 扩展字段_字符串_4
   */
  private String extstr4;

  /**
   * 扩展字段_字符串_5
   */
  private String extstr5;

  /**
   * 扩展字段_字符串_6
   */
  private String extstr6;

  /**
   * 扩展字段_字符串_7
   */
  private String extstr7;

  /**
   * 扩展字段_字符串_8
   */
  private String extstr8;

  /**
   * 扩展字段_字符串_9
   */
  private String extstr9;

  /**
   * 扩展字段_字符串_10
   */
  private String extstr10;

  /**
   * 模版变量Id
   */
  private String vvariableid;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 转换方式信息
   */
  @TableField("docTransformer")
  private String docTransformer;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("latest", latest);
      map.put("srcids", srcids);
      map.put("belongTenant", belongTenant);
      map.put("collectionAccount", collectionAccount);
      map.put("collectionBatch", collectionBatch);
      map.put("collectionDate", BocpGenUtils.toTimestamp(collectionDate));
      map.put("purchaseCompanyTaxNo", purchaseCompanyTaxNo);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("purchaseCompanyCode", purchaseCompanyCode);
      map.put("purchaseCompanyName", purchaseCompanyName);
      map.put("regionCode", regionCode);
      map.put("regionName", regionName);
      map.put("purchaseStoreCode", purchaseStoreCode);
      map.put("purchaseStoreGLN", purchaseStoreGLN);
      map.put("purchaseStoreName", purchaseStoreName);
      map.put("purchaseStorageCenterCode", purchaseStorageCenterCode);
      map.put("purchaseStorageCenterName", purchaseStorageCenterName);
      map.put("categoryCode", categoryCode);
      map.put("categoryName", categoryName);
      map.put("sellerCode", sellerCode);
      map.put("sellerName", sellerName);
      map.put("itemCode", itemCode);
      map.put("barcode", barcode);
      map.put("itemSubCode", itemSubCode);
      map.put("itemDesc", itemDesc);
      map.put("brand", brand);
      map.put("standards", standards);
      map.put("model", model);
      map.put("itemStatus", itemStatus);
      map.put("unit", unit);
      map.put("sectionType", sectionType);
      map.put("sectionDate", sectionDate);
      map.put("purchaseQty", purchaseQty);
      map.put("purchaseAmt", purchaseAmt);
      map.put("averagePurchaseAmt", averagePurchaseAmt);
      map.put("salesQty", salesQty);
      map.put("saleAmt", saleAmt);
      map.put("averageSaleQty", averageSaleQty);
      map.put("stockDate", BocpGenUtils.toTimestamp(stockDate));
      map.put("stockQty", stockQty);
      map.put("stockAmt", stockAmt);
      map.put("transitQty", transitQty);
      map.put("transitAmt", transitAmt);
      map.put("remark", remark);
      map.put("extstr1", extstr1);
      map.put("extstr2", extstr2);
      map.put("extstr3", extstr3);
      map.put("extstr4", extstr4);
      map.put("extstr5", extstr5);
      map.put("extstr6", extstr6);
      map.put("extstr7", extstr7);
      map.put("extstr8", extstr8);
      map.put("extstr9", extstr9);
      map.put("extstr10", extstr10);
      map.put("vvariableid", vvariableid);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("docTransformer", docTransformer);
      return map;
  }

  public static Inventory fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Inventory entity = new Inventory();
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSrcids((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionBatch")) {
      Object obj = map.get("collectionBatch");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionBatch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionDate")) {
      Object obj = map.get("collectionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCollectionDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCollectionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCollectionDate(null);
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStorageCenterCode")) {
      Object obj = map.get("purchaseStorageCenterCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseStorageCenterCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStorageCenterName")) {
      Object obj = map.get("purchaseStorageCenterName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseStorageCenterName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryName")) {
      Object obj = map.get("categoryName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCategoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSubCode")) {
      Object obj = map.get("itemSubCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("model")) {
      Object obj = map.get("model");
      if(obj != null) {
        if(obj instanceof String){
          entity.setModel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemStatus")) {
      Object obj = map.get("itemStatus");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setItemStatus((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setItemStatus(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setItemStatus(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setItemStatus(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setItemStatus(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sectionType")) {
      Object obj = map.get("sectionType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSectionType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sectionDate")) {
      Object obj = map.get("sectionDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSectionDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseQty")) {
      Object obj = map.get("purchaseQty");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseQty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseAmt")) {
      Object obj = map.get("purchaseAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPurchaseAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPurchaseAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPurchaseAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPurchaseAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaseAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("averagePurchaseAmt")) {
      Object obj = map.get("averagePurchaseAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAveragePurchaseAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAveragePurchaseAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAveragePurchaseAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAveragePurchaseAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAveragePurchaseAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesQty")) {
      Object obj = map.get("salesQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSalesQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("saleAmt")) {
      Object obj = map.get("saleAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSaleAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSaleAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSaleAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSaleAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSaleAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("averageSaleQty")) {
      Object obj = map.get("averageSaleQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAverageSaleQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAverageSaleQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAverageSaleQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAverageSaleQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAverageSaleQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("stockDate")) {
      Object obj = map.get("stockDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStockDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setStockDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStockDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStockDate(null);
      }
    }
    if(map.containsKey("stockQty")) {
      Object obj = map.get("stockQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setStockQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setStockQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setStockQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setStockQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStockQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("stockAmt")) {
      Object obj = map.get("stockAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setStockAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setStockAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setStockAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setStockAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStockAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("transitQty")) {
      Object obj = map.get("transitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTransitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTransitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTransitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTransitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTransitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("transitAmt")) {
      Object obj = map.get("transitAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTransitAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTransitAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTransitAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTransitAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTransitAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr1")) {
      Object obj = map.get("extstr1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtstr1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr2")) {
      Object obj = map.get("extstr2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtstr2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr3")) {
      Object obj = map.get("extstr3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtstr3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr4")) {
      Object obj = map.get("extstr4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtstr4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr5")) {
      Object obj = map.get("extstr5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtstr5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr6")) {
      Object obj = map.get("extstr6");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtstr6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr7")) {
      Object obj = map.get("extstr7");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtstr7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr8")) {
      Object obj = map.get("extstr8");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtstr8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr9")) {
      Object obj = map.get("extstr9");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtstr9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr10")) {
      Object obj = map.get("extstr10");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtstr10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVvariableid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDocTransformer((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSrcids((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionBatch")) {
      Object obj = map.get("collectionBatch");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionBatch((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionDate")) {
      Object obj = map.get("collectionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCollectionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCollectionDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCollectionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCollectionDate(null);
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreGLN((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStorageCenterCode")) {
      Object obj = map.get("purchaseStorageCenterCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStorageCenterCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStorageCenterName")) {
      Object obj = map.get("purchaseStorageCenterName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStorageCenterName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategoryCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("categoryName")) {
      Object obj = map.get("categoryName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategoryName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBarcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemSubCode")) {
      Object obj = map.get("itemSubCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemSubCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStandards((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("model")) {
      Object obj = map.get("model");
      if(obj != null) {
        if(obj instanceof String) {
          this.setModel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemStatus")) {
      Object obj = map.get("itemStatus");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setItemStatus((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setItemStatus(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setItemStatus(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setItemStatus(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setItemStatus(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sectionType")) {
      Object obj = map.get("sectionType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSectionType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sectionDate")) {
      Object obj = map.get("sectionDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSectionDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseQty")) {
      Object obj = map.get("purchaseQty");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseQty((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseAmt")) {
      Object obj = map.get("purchaseAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPurchaseAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPurchaseAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPurchaseAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setPurchaseAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaseAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("averagePurchaseAmt")) {
      Object obj = map.get("averagePurchaseAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAveragePurchaseAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAveragePurchaseAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAveragePurchaseAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAveragePurchaseAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAveragePurchaseAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("salesQty")) {
      Object obj = map.get("salesQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setSalesQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("saleAmt")) {
      Object obj = map.get("saleAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSaleAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSaleAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSaleAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setSaleAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSaleAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("averageSaleQty")) {
      Object obj = map.get("averageSaleQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAverageSaleQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAverageSaleQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAverageSaleQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAverageSaleQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAverageSaleQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("stockDate")) {
      Object obj = map.get("stockDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setStockDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setStockDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setStockDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setStockDate(null);
      }
    }
    if(map.containsKey("stockQty")) {
      Object obj = map.get("stockQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setStockQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setStockQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setStockQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setStockQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setStockQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("stockAmt")) {
      Object obj = map.get("stockAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setStockAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setStockAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setStockAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setStockAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setStockAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("transitQty")) {
      Object obj = map.get("transitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTransitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTransitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTransitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTransitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTransitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("transitAmt")) {
      Object obj = map.get("transitAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTransitAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTransitAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTransitAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTransitAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTransitAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr1")) {
      Object obj = map.get("extstr1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr2")) {
      Object obj = map.get("extstr2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr3")) {
      Object obj = map.get("extstr3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr4")) {
      Object obj = map.get("extstr4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr5")) {
      Object obj = map.get("extstr5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr6")) {
      Object obj = map.get("extstr6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr7")) {
      Object obj = map.get("extstr7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr8")) {
      Object obj = map.get("extstr8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr9")) {
      Object obj = map.get("extstr9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr10")) {
      Object obj = map.get("extstr10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVvariableid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocTransformer((String)obj);
        }
      } else {
      }
    }
  }
}
