package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * doc_transfer_state
 * </p>
 *
 * @author ultraman
 * @since 2024-05-13
 */
public enum DocTransferState {

    _0("0", "未转换"),
    _1("1", "转换失败"),
    _2("2", "转换成功");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DocTransferState(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DocTransferState fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
