package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * write_off_type
 * </p>
 *
 * @author ultraman
 * @since 2024-05-13
 */
public enum WriteOffType {

    NON("NON", "非冲销"),
    WRITE_OFF("WRITE_OFF", "红冲"),
    CANCEL_WRITE_OFF("CANCEL_WRITE_OFF", "蓝冲");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    WriteOffType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WriteOffType fromCode(String code){
        switch(code) {
            case "NON":
                return NON;
            case "WRITE_OFF":
                return WRITE_OFF;
            case "CANCEL_WRITE_OFF":
                return CANCEL_WRITE_OFF;
            default:
                return null;
        }
    }
}
