package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * document_pool
 * </p>
 *
 * @author ultraman
 * @since 2024-07-09
 */
public enum DocumentPool {

    UNIFIED_POOL("unifiedPool", "统一单据池"),
    TENANT_POOL("tenantPool", "租户单据池");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DocumentPool(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DocumentPool fromCode(String code){
        switch(code) {
            case "unifiedPool":
                return UNIFIED_POOL;
            case "tenantPool":
                return TENANT_POOL;
            default:
                return null;
        }
    }
}
