package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * order_goods_manage_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-09
 */
public enum OrderGoodsManageType {

    SINGLE_ORDER("singleOrder", "单张订单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OrderGoodsManageType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrderGoodsManageType fromCode(String code){
        switch(code) {
            case "singleOrder":
                return SINGLE_ORDER;
            default:
                return null;
        }
    }
}
