package com.xforceplus.ultraman.app.arterydocument.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-07-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MarketAccount implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 所属租户
   */
  @TableField("belongTenant")
  private String belongTenant;

  /**
   * 所属租户编码
   */
  @TableField("belongTenantCode")
  private String belongTenantCode;

  /**
   * 零售商编码
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 零售商描述
   */
  @TableField("purchaseRetailerName")
  private String purchaseRetailerName;

  /**
   * 所属分公司编码
   */
  @TableField("branchCode")
  private String branchCode;

  /**
   * 所属分公司名称
   */
  @TableField("branchName")
  private String branchName;

  /**
   * 所属销售组织编码
   */
  @TableField("salesOrg")
  private String salesOrg;

  /**
   * 所属销售组织名称
   */
  @TableField("salesOrgName")
  private String salesOrgName;

  /**
   * 商超账号
   */
  @TableField("collectionAccount")
  private String collectionAccount;

  /**
   * 商超账号扩展属性1
   */
  @TableField("accountExt1")
  private String accountExt1;

  /**
   * 商超账号扩展属性2
   */
  @TableField("accountExt2")
  private String accountExt2;

  /**
   * 商超账号扩展属性3
   */
  @TableField("accountExt3")
  private String accountExt3;

  /**
   * 密钥
   */
  @TableField("accountSecretKey")
  private String accountSecretKey;

  /**
   * 账号启用状态
   */
  @TableField("accountActivationStatus")
  private String accountActivationStatus;

  /**
   * 账号运行状态
   */
  @TableField("accountRunningStatus")
  private String accountRunningStatus;

  /**
   * 最后成功运行时间
   */
  @TableField("lastSuccessfulRuntime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lastSuccessfulRuntime;

  /**
   * 异常信息
   */
  @TableField("abnormalInfo")
  private String abnormalInfo;

  /**
   * 密钥状态
   */
  @TableField("secretKeyStatus")
  private String secretKeyStatus;

  /**
   * 密钥时间
   */
  @TableField("secretKeyTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime secretKeyTime;

  /**
   * 系统账号编号
   */
  @TableField("pSysAccountNo")
  private String pSysAccountNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("belongTenant", belongTenant);
      map.put("belongTenantCode", belongTenantCode);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("branchCode", branchCode);
      map.put("branchName", branchName);
      map.put("salesOrg", salesOrg);
      map.put("salesOrgName", salesOrgName);
      map.put("collectionAccount", collectionAccount);
      map.put("accountExt1", accountExt1);
      map.put("accountExt2", accountExt2);
      map.put("accountExt3", accountExt3);
      map.put("accountSecretKey", accountSecretKey);
      map.put("accountActivationStatus", accountActivationStatus);
      map.put("accountRunningStatus", accountRunningStatus);
      map.put("lastSuccessfulRuntime", BocpGenUtils.toTimestamp(lastSuccessfulRuntime));
      map.put("abnormalInfo", abnormalInfo);
      map.put("secretKeyStatus", secretKeyStatus);
      map.put("secretKeyTime", BocpGenUtils.toTimestamp(secretKeyTime));
      map.put("pSysAccountNo", pSysAccountNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static MarketAccount fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    MarketAccount entity = new MarketAccount();
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongTenantCode")) {
      Object obj = map.get("belongTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("branchCode")) {
      Object obj = map.get("branchCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBranchCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("branchName")) {
      Object obj = map.get("branchName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBranchName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrg")) {
      Object obj = map.get("salesOrg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrgName")) {
      Object obj = map.get("salesOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountExt1")) {
      Object obj = map.get("accountExt1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountExt2")) {
      Object obj = map.get("accountExt2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountExt3")) {
      Object obj = map.get("accountExt3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountSecretKey")) {
      Object obj = map.get("accountSecretKey");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountSecretKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountActivationStatus")) {
      Object obj = map.get("accountActivationStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountActivationStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountRunningStatus")) {
      Object obj = map.get("accountRunningStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountRunningStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastSuccessfulRuntime")) {
      Object obj = map.get("lastSuccessfulRuntime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLastSuccessfulRuntime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setLastSuccessfulRuntime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastSuccessfulRuntime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLastSuccessfulRuntime(null);
      }
    }
    if(map.containsKey("abnormalInfo")) {
      Object obj = map.get("abnormalInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAbnormalInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("secretKeyStatus")) {
      Object obj = map.get("secretKeyStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSecretKeyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("secretKeyTime")) {
      Object obj = map.get("secretKeyTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSecretKeyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSecretKeyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSecretKeyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSecretKeyTime(null);
      }
    }
    if(map.containsKey("pSysAccountNo")) {
      Object obj = map.get("pSysAccountNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSysAccountNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("belongTenantCode")) {
      Object obj = map.get("belongTenantCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("branchCode")) {
      Object obj = map.get("branchCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBranchCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("branchName")) {
      Object obj = map.get("branchName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBranchName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesOrg")) {
      Object obj = map.get("salesOrg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesOrg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesOrgName")) {
      Object obj = map.get("salesOrgName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesOrgName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accountExt1")) {
      Object obj = map.get("accountExt1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accountExt2")) {
      Object obj = map.get("accountExt2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accountExt3")) {
      Object obj = map.get("accountExt3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accountSecretKey")) {
      Object obj = map.get("accountSecretKey");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountSecretKey((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accountActivationStatus")) {
      Object obj = map.get("accountActivationStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountActivationStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accountRunningStatus")) {
      Object obj = map.get("accountRunningStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountRunningStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lastSuccessfulRuntime")) {
      Object obj = map.get("lastSuccessfulRuntime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLastSuccessfulRuntime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setLastSuccessfulRuntime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastSuccessfulRuntime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setLastSuccessfulRuntime(null);
      }
    }
    if(map.containsKey("abnormalInfo")) {
      Object obj = map.get("abnormalInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAbnormalInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("secretKeyStatus")) {
      Object obj = map.get("secretKeyStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSecretKeyStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("secretKeyTime")) {
      Object obj = map.get("secretKeyTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSecretKeyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSecretKeyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSecretKeyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSecretKeyTime(null);
      }
    }
    if(map.containsKey("pSysAccountNo")) {
      Object obj = map.get("pSysAccountNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSysAccountNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
