package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-30
 */
public enum InvoiceStatus {

    WAITING("waiting", "待前序流程处理"),
    TO_BE_INVOICED("toBeInvoiced", "待开票"),
    INVOICING("invoicing", "开票中"),
    INVOICED("invoiced", "开票完成");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceStatus fromCode(String code){
        switch(code) {
            case "waiting":
                return WAITING;
            case "toBeInvoiced":
                return TO_BE_INVOICED;
            case "invoicing":
                return INVOICING;
            case "invoiced":
                return INVOICED;
            default:
                return null;
        }
    }
}
