package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * send_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-07-30
 */
public enum SendFlag {

    Y("Y", "是"),
    N("N", "否");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SendFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SendFlag fromCode(String code){
        switch(code) {
            case "Y":
                return Y;
            case "N":
                return N;
            default:
                return null;
        }
    }
}
