package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * batch_transfer_status
 * </p>
 *
 * @author ultraman
 * @since 2025-02-18
 */
public enum BatchTransferStatus {

    _1("1", "成功"),
    _3("3", "异常");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BatchTransferStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BatchTransferStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
