package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * purchase_retailer
 * </p>
 *
 * @author ultraman
 * @since 2025-02-18
 */
public enum PurchaseRetailer {

    CRV("crv", "华润万家"),
    CRV_O_L_E("crvOLE", "华润OLE"),
    RTMART("rtmart", "大润发"),
    YONGHUI("yonghui", "永辉"),
    SUGUO("suguo", "华润苏果"),
    JIAJIAYUE("jiajiayue", "家家悦");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PurchaseRetailer(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PurchaseRetailer fromCode(String code){
        switch(code) {
            case "crv":
                return CRV;
            case "crvOLE":
                return CRV_O_L_E;
            case "rtmart":
                return RTMART;
            case "yonghui":
                return YONGHUI;
            case "suguo":
                return SUGUO;
            case "jiajiayue":
                return JIAJIAYUE;
            default:
                return null;
        }
    }
}
