package com.xforceplus.ultraman.app.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Payment implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 所属租户
   */
  @TableField("belongTenant")
  private String belongTenant;

  /**
   * 关联商超账号
   */
  @TableField("collectionAccount")
  private String collectionAccount;

  /**
   * 零售商编码
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 零售商描述
   */
  @TableField("purchaseRetailerName")
  private String purchaseRetailerName;

  /**
   * 付款单号
   */
  @TableField("paymentNo")
  private String paymentNo;

  /**
   * 付款单类型
   */
  @TableField("paymentType")
  private String paymentType;

  /**
   * 支付日期
   */
  @TableField("paymentDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentDate;

  /**
   * 结算顺序
   */
  @TableField("settlementSequence")
  private String settlementSequence;

  /**
   * 创建日期
   */
  @TableField("creationDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime creationDate;

  /**
   * 付款方式
   */
  @TableField("paymentMethod")
  private String paymentMethod;

  /**
   * 付款银行
   */
  @TableField("paymentBank")
  private String paymentBank;

  /**
   * 是否退票
   */
  private String refund;

  /**
   * 随机密码
   */
  @TableField("randomPassword")
  private String randomPassword;

  /**
   * 付款结果
   */
  @TableField("paymentResults")
  private String paymentResults;

  /**
   * 收款方统一社会信用代码
   */
  @TableField("receiverCompanyTaxNo")
  private String receiverCompanyTaxNo;

  /**
   * 收款方公司编码
   */
  @TableField("receiverCompanyCode")
  private String receiverCompanyCode;

  /**
   * 收款方公司名称
   */
  @TableField("receiverCompanyName")
  private String receiverCompanyName;

  /**
   * 付款方公司编码
   */
  @TableField("payCompanyCode")
  private String payCompanyCode;

  /**
   * 付款方公司名称
   */
  @TableField("payCompanyName")
  private String payCompanyName;

  /**
   * 付款方统一社会信用代码
   */
  @TableField("payCompanyTaxNo")
  private String payCompanyTaxNo;

  /**
   * 支付金额
   */
  @TableField("payAmount")
  private BigDecimal payAmount;

  /**
   * 备注
   */
  private String remark;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 是否是最新版本
   */
  private Boolean latest;

  /**
   * 原始单据Id数组
   */
  private String srcids;

  /**
   * 数据MD5摘要
   */
  private String md5;

  /**
   * 版本号
   */
  @TableField("versionNo")
  private String versionNo;

  /**
   * 模版变量Id
   */
  private String vvariableid;

  /**
   * 转换方式信息
   */
  @TableField("docTransformer")
  private String docTransformer;

  /**
   * 平台业务Id
   */
  @TableField("pBusinessId")
  private String pBusinessId;

  /**
   * 票据号码
   */
  @TableField("billNo")
  private String billNo;

  /**
   * 出票日
   */
  @TableField("billIssueDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billIssueDate;

  /**
   * 销方冲账状态
   */
  @TableField("pSellerOffsetStatus")
  private String pSellerOffsetStatus;

  /**
   * 单据来源
   */
  @TableField("pSourceFrom")
  private String pSourceFrom;

  /**
   * 销方销售组编码
   */
  @TableField("sSalesGroupCode")
  private String sSalesGroupCode;

  /**
   * 销方销售组名称
   */
  @TableField("sSalesGroupName")
  private String sSalesGroupName;

  /**
   * 自定义字段1
   */
  private String attribute1;

  /**
   * 自定义字段2
   */
  private String attribute2;

  /**
   * 自定义字段3
   */
  private String attribute3;

  /**
   * 自定义字段4
   */
  private String attribute4;

  /**
   * 自定义字段5
   */
  private String attribute5;

  /**
   * 自定义字段6
   */
  private String attribute6;

  /**
   * 自定义字段7
   */
  private String attribute7;

  /**
   * 自定义字段8
   */
  private String attribute8;

  /**
   * 业务Id
   */
  @TableField("businessId")
  private Long businessId;

  /**
   * 到期日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deadline;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("belongTenant", belongTenant);
      map.put("collectionAccount", collectionAccount);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("paymentNo", paymentNo);
      map.put("paymentType", paymentType);
      map.put("paymentDate", BocpGenUtils.toTimestamp(paymentDate));
      map.put("settlementSequence", settlementSequence);
      map.put("creationDate", BocpGenUtils.toTimestamp(creationDate));
      map.put("paymentMethod", paymentMethod);
      map.put("paymentBank", paymentBank);
      map.put("refund", refund);
      map.put("randomPassword", randomPassword);
      map.put("paymentResults", paymentResults);
      map.put("receiverCompanyTaxNo", receiverCompanyTaxNo);
      map.put("receiverCompanyCode", receiverCompanyCode);
      map.put("receiverCompanyName", receiverCompanyName);
      map.put("payCompanyCode", payCompanyCode);
      map.put("payCompanyName", payCompanyName);
      map.put("payCompanyTaxNo", payCompanyTaxNo);
      map.put("payAmount", payAmount);
      map.put("remark", remark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("latest", latest);
      map.put("srcids", srcids);
      map.put("md5", md5);
      map.put("versionNo", versionNo);
      map.put("vvariableid", vvariableid);
      map.put("docTransformer", docTransformer);
      map.put("pBusinessId", pBusinessId);
      map.put("billNo", billNo);
      map.put("billIssueDate", BocpGenUtils.toTimestamp(billIssueDate));
      map.put("pSellerOffsetStatus", pSellerOffsetStatus);
      map.put("pSourceFrom", pSourceFrom);
      map.put("sSalesGroupCode", sSalesGroupCode);
      map.put("sSalesGroupName", sSalesGroupName);
      map.put("attribute1", attribute1);
      map.put("attribute2", attribute2);
      map.put("attribute3", attribute3);
      map.put("attribute4", attribute4);
      map.put("attribute5", attribute5);
      map.put("attribute6", attribute6);
      map.put("attribute7", attribute7);
      map.put("attribute8", attribute8);
      map.put("businessId", businessId);
      map.put("deadline", BocpGenUtils.toTimestamp(deadline));

      return map;
  }

  public static Payment fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Payment entity = new Payment();
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentDate(null);
      }
    }
    if(map.containsKey("settlementSequence")) {
      Object obj = map.get("settlementSequence");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementSequence((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("creationDate")) {
      Object obj = map.get("creationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreationDate(null);
      }
    }
    if(map.containsKey("paymentMethod")) {
      Object obj = map.get("paymentMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentBank")) {
      Object obj = map.get("paymentBank");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund")) {
      Object obj = map.get("refund");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefund((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("randomPassword")) {
      Object obj = map.get("randomPassword");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRandomPassword((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentResults")) {
      Object obj = map.get("paymentResults");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentResults((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiverCompanyTaxNo")) {
      Object obj = map.get("receiverCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiverCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiverCompanyCode")) {
      Object obj = map.get("receiverCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiverCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiverCompanyName")) {
      Object obj = map.get("receiverCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiverCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payCompanyCode")) {
      Object obj = map.get("payCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payCompanyName")) {
      Object obj = map.get("payCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payCompanyTaxNo")) {
      Object obj = map.get("payCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payAmount")) {
      Object obj = map.get("payAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSrcids((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("md5")) {
      Object obj = map.get("md5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMd5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVvariableid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocTransformer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billIssueDate")) {
      Object obj = map.get("billIssueDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillIssueDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBillIssueDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillIssueDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillIssueDate(null);
      }
    }
    if(map.containsKey("pSellerOffsetStatus")) {
      Object obj = map.get("pSellerOffsetStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSellerOffsetStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSourceFrom")) {
      Object obj = map.get("pSourceFrom");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSourceFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupCode")) {
      Object obj = map.get("sSalesGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupName")) {
      Object obj = map.get("sSalesGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute1")) {
      Object obj = map.get("attribute1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute2")) {
      Object obj = map.get("attribute2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute3")) {
      Object obj = map.get("attribute3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute4")) {
      Object obj = map.get("attribute4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute5")) {
      Object obj = map.get("attribute5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute6")) {
      Object obj = map.get("attribute6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute7")) {
      Object obj = map.get("attribute7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute8")) {
      Object obj = map.get("attribute8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("deadline")) {
      Object obj = map.get("deadline");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeadline(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDeadline((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeadline(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeadline(null);
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPaymentDate(null);
      }
    }
    if(map.containsKey("settlementSequence")) {
      Object obj = map.get("settlementSequence");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementSequence((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("creationDate")) {
      Object obj = map.get("creationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreationDate(null);
      }
    }
    if(map.containsKey("paymentMethod")) {
      Object obj = map.get("paymentMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentBank")) {
      Object obj = map.get("paymentBank");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentBank((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund")) {
      Object obj = map.get("refund");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefund((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("randomPassword")) {
      Object obj = map.get("randomPassword");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRandomPassword((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentResults")) {
      Object obj = map.get("paymentResults");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentResults((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiverCompanyTaxNo")) {
      Object obj = map.get("receiverCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiverCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiverCompanyCode")) {
      Object obj = map.get("receiverCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiverCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiverCompanyName")) {
      Object obj = map.get("receiverCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiverCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payCompanyCode")) {
      Object obj = map.get("payCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payCompanyName")) {
      Object obj = map.get("payCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payCompanyTaxNo")) {
      Object obj = map.get("payCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payAmount")) {
      Object obj = map.get("payAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSrcids((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("md5")) {
      Object obj = map.get("md5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMd5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVvariableid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocTransformer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billIssueDate")) {
      Object obj = map.get("billIssueDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBillIssueDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBillIssueDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillIssueDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBillIssueDate(null);
      }
    }
    if(map.containsKey("pSellerOffsetStatus")) {
      Object obj = map.get("pSellerOffsetStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSellerOffsetStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pSourceFrom")) {
      Object obj = map.get("pSourceFrom");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSourceFrom((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesGroupCode")) {
      Object obj = map.get("sSalesGroupCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesGroupCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesGroupName")) {
      Object obj = map.get("sSalesGroupName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesGroupName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute1")) {
      Object obj = map.get("attribute1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute2")) {
      Object obj = map.get("attribute2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute3")) {
      Object obj = map.get("attribute3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute4")) {
      Object obj = map.get("attribute4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute5")) {
      Object obj = map.get("attribute5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute6")) {
      Object obj = map.get("attribute6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute7")) {
      Object obj = map.get("attribute7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute8")) {
      Object obj = map.get("attribute8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBusinessId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("deadline")) {
      Object obj = map.get("deadline");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDeadline(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDeadline((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDeadline(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDeadline(null);
      }
    }
  }
}
