package com.xforceplus.ultraman.app.arterydocument.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SysTypeMapping implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 所属租户
   */
  @TableField("belongTenant")
  private String belongTenant;

  /**
   * 所属租户名称
   */
  @TableField("belongTenantName")
  private String belongTenantName;

  /**
   * 配置级别
   */
  @TableField("configLevel")
  private String configLevel;

  /**
   * 源配置编码
   */
  @TableField("sourceTypeCode")
  private String sourceTypeCode;

  /**
   * 源配置名称
   */
  @TableField("sourceTypeName")
  private String sourceTypeName;

  /**
   * 源配置项编码
   */
  @TableField("sourceItemCode")
  private String sourceItemCode;

  /**
   * 源配置项名称
   */
  @TableField("sourceItemName")
  private String sourceItemName;

  /**
   * 目标配置编码
   */
  @TableField("targetTypeCode")
  private String targetTypeCode;

  /**
   * 目标配置名称
   */
  @TableField("targetTypeName")
  private String targetTypeName;

  /**
   * 目标配置项编码
   */
  @TableField("targetItemCode")
  private String targetItemCode;

  /**
   * 目标配置项名称
   */
  @TableField("targetItemName")
  private String targetItemName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("belongTenant", belongTenant);
      map.put("belongTenantName", belongTenantName);
      map.put("configLevel", configLevel);
      map.put("sourceTypeCode", sourceTypeCode);
      map.put("sourceTypeName", sourceTypeName);
      map.put("sourceItemCode", sourceItemCode);
      map.put("sourceItemName", sourceItemName);
      map.put("targetTypeCode", targetTypeCode);
      map.put("targetTypeName", targetTypeName);
      map.put("targetItemCode", targetItemCode);
      map.put("targetItemName", targetItemName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static SysTypeMapping fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SysTypeMapping entity = new SysTypeMapping();
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongTenantName")) {
      Object obj = map.get("belongTenantName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("configLevel")) {
      Object obj = map.get("configLevel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConfigLevel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sourceTypeCode")) {
      Object obj = map.get("sourceTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sourceTypeName")) {
      Object obj = map.get("sourceTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sourceItemCode")) {
      Object obj = map.get("sourceItemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sourceItemName")) {
      Object obj = map.get("sourceItemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("targetTypeCode")) {
      Object obj = map.get("targetTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTargetTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("targetTypeName")) {
      Object obj = map.get("targetTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTargetTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("targetItemCode")) {
      Object obj = map.get("targetItemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTargetItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("targetItemName")) {
      Object obj = map.get("targetItemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTargetItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("belongTenantName")) {
      Object obj = map.get("belongTenantName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenantName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("configLevel")) {
      Object obj = map.get("configLevel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfigLevel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sourceTypeCode")) {
      Object obj = map.get("sourceTypeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sourceTypeName")) {
      Object obj = map.get("sourceTypeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sourceItemCode")) {
      Object obj = map.get("sourceItemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sourceItemName")) {
      Object obj = map.get("sourceItemName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("targetTypeCode")) {
      Object obj = map.get("targetTypeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTargetTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("targetTypeName")) {
      Object obj = map.get("targetTypeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTargetTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("targetItemCode")) {
      Object obj = map.get("targetItemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTargetItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("targetItemName")) {
      Object obj = map.get("targetItemName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTargetItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
