package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 结算单行单据类别
 * </p>
 *
 * @author ultraman
 * @since 2023-08-01
 */
public enum DocumentCategory {

    GRN("GRN", "收货单"),
    RTV("RTV", "退货单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DocumentCategory(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DocumentCategory fromCode(String code){
        switch(code) {
            case "GRN":
                return GRN;
            case "RTV":
                return RTV;
            default:
                return null;
        }
    }
}
