package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 销方冲账状态
 * </p>
 *
 * @author ultraman
 * @since 2023-08-01
 */
public enum SellerOffsetStatus {

    UNMATCH("unmatch", "未匹配"),
    MATCHING("matching", "匹配中"),
    TO_BE_CONFIRMED("toBeConfirmed", "待确认"),
    CONFIRMED("confirmed", "已确认");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SellerOffsetStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SellerOffsetStatus fromCode(String code){
        switch(code) {
            case "unmatch":
                return UNMATCH;
            case "matching":
                return MATCHING;
            case "toBeConfirmed":
                return TO_BE_CONFIRMED;
            case "confirmed":
                return CONFIRMED;
            default:
                return null;
        }
    }
}
