package com.xforceplus.ultraman.app.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-08-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SettlementBill implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 所属租户
   */
  @TableField("belongTenant")
  private String belongTenant;

  /**
   * 关联商超账号
   */
  @TableField("collectionAccount")
  private String collectionAccount;

  /**
   * 零售商编码
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 零售商描述
   */
  @TableField("purchaseRetailerName")
  private String purchaseRetailerName;

  /**
   * 结算单编号
   */
  @TableField("settlementNo")
  private String settlementNo;

  /**
   * 单据类型
   */
  @TableField("documentType")
  private String documentType;

  /**
   * 单据状态
   */
  @TableField("documentStatus")
  private String documentStatus;

  /**
   * 版本号
   */
  @TableField("versionNo")
  private String versionNo;

  /**
   * 业态编码
   */
  @TableField("purchaseBusinessTypeNo")
  private String purchaseBusinessTypeNo;

  /**
   * 业态名称
   */
  @TableField("purchaseBusinessTypeName")
  private String purchaseBusinessTypeName;

  /**
   * 城市
   */
  @TableField("purchaseCity")
  private String purchaseCity;

  /**
   * BU
   */
  @TableField("businessUnit")
  private String businessUnit;

  /**
   * 区域编码
   */
  @TableField("regionCode")
  private String regionCode;

  /**
   * 区域名称
   */
  @TableField("regionName")
  private String regionName;

  /**
   * 购方门店编码
   */
  @TableField("purchaseStoreCode")
  private String purchaseStoreCode;

  /**
   * 购方门店GLN
   */
  @TableField("purchaseStoreGLN")
  private String purchaseStoreGLN;

  /**
   * 购方门店名称
   */
  @TableField("purchaseStoreName")
  private String purchaseStoreName;

  /**
   * 大仓编码
   */
  @TableField("purchaseStorageCenterCode")
  private String purchaseStorageCenterCode;

  /**
   * 大仓名称
   */
  @TableField("purchaseStorageCenterName")
  private String purchaseStorageCenterName;

  /**
   * 购方统一社会信用代码
   */
  @TableField("purchaseCompanyTaxNo")
  private String purchaseCompanyTaxNo;

  /**
   * 购方公司编码
   */
  @TableField("purchaseCompanyCode")
  private String purchaseCompanyCode;

  /**
   * 购方公司名称
   */
  @TableField("purchaseCompanyName")
  private String purchaseCompanyName;

  /**
   * 销方类型
   */
  @TableField("sellerType")
  private String sellerType;

  /**
   * 销方统一社会信用代码
   */
  @TableField("sellerCompanyTaxNo")
  private String sellerCompanyTaxNo;

  /**
   * 销方公司编码
   */
  @TableField("sellerCompanyCode")
  private String sellerCompanyCode;

  /**
   * 销方公司名称
   */
  @TableField("sellerCompanyName")
  private String sellerCompanyName;

  /**
   * 销方编码
   */
  @TableField("sellerCode")
  private String sellerCode;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 账扣金额(含税)
   */
  @TableField("debitAmt")
  private BigDecimal debitAmt;

  /**
   * 票扣金额(含税)
   */
  @TableField("invoicedDeductionAmt")
  private BigDecimal invoicedDeductionAmt;

  /**
   * 应付金额(含税)
   */
  @TableField("payableAmtWithTax")
  private BigDecimal payableAmtWithTax;

  /**
   * 总金额（含税）
   */
  @TableField("totalAmtWithTax")
  private BigDecimal totalAmtWithTax;

  /**
   * 总金额（不含税）
   */
  @TableField("totalAmtWithoutTax")
  private BigDecimal totalAmtWithoutTax;

  /**
   * 建议开票金额（含税）
   */
  @TableField("sujestInvoicedAmtWithTax")
  private BigDecimal sujestInvoicedAmtWithTax;

  /**
   * 建议开票金额（不含税）
   */
  @TableField("sujestInvoicedAmtWithoutTax")
  private BigDecimal sujestInvoicedAmtWithoutTax;

  /**
   * 建议开票税额
   */
  @TableField("sujestInvoicedTax")
  private BigDecimal sujestInvoicedTax;

  /**
   * 实收发票金额（含税）
   */
  @TableField("invoicedAmtWithTax")
  private BigDecimal invoicedAmtWithTax;

  /**
   * 结算日期
   */
  @TableField("settlementDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementDate;

  /**
   * 制单日期
   */
  @TableField("creationDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime creationDate;

  /**
   * 审核日期
   */
  @TableField("approveDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime approveDate;

  /**
   * 制单人
   */
  @TableField("createdBy")
  private String createdBy;

  /**
   * 审核人
   */
  @TableField("approvedBy")
  private String approvedBy;

  /**
   * 开票数据确认人
   */
  @TableField("invoiceConfirmBy")
  private String invoiceConfirmBy;

  /**
   * 开票数据确认时间
   */
  @TableField("invoiceConfirmTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceConfirmTime;

  /**
   * 发票录入人
   */
  @TableField("invoiceCreatedBy")
  private String invoiceCreatedBy;

  /**
   * 发票录入时间
   */
  @TableField("invoiceCreatedTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceCreatedTime;

  /**
   * 物流模式
   */
  @TableField("logisticsMode")
  private String logisticsMode;

  /**
   * 币种编码
   */
  @TableField("currencyCode")
  private String currencyCode;

  /**
   * 币种
   */
  private String currency;

  /**
   * 结算方式编码
   */
  @TableField("settlementCode")
  private String settlementCode;

  /**
   * 结算方式名称
   */
  @TableField("settlementName")
  private String settlementName;

  /**
   * 付款条件编码
   */
  @TableField("payCondtCode")
  private String payCondtCode;

  /**
   * 付款条件名称
   */
  @TableField("payCondtName")
  private String payCondtName;

  /**
   * 计划付款日期
   */
  @TableField("schedulePayDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime schedulePayDate;

  /**
   * 实际付款日期
   */
  @TableField("payDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime payDate;

  /**
   * 实际付款金额（含税）
   */
  @TableField("payAmtWithTax")
  private BigDecimal payAmtWithTax;

  /**
   * 备注
   */
  private String remark;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 是否最新版本
   */
  private Boolean latest;

  /**
   * 原单据id集合
   */
  private String srcids;

  /**
   * 单据MD5
   */
  private String md5;

  /**
   * 业务id
   */
  @TableField("businessId")
  private Long businessId;

  /**
   * 价格方式
   */
  @TableField("priceStatus")
  private Long priceStatus;

  /**
   * 业务Id
   */
  @TableField("pBusinessId")
  private String pBusinessId;

  /**
   * 销方开票状态
   */
  @TableField("pSellerInvoiceStatus")
  private String pSellerInvoiceStatus;

  /**
   * 平台取消标识
   */
  @TableField("pCancelFlag")
  private String pCancelFlag;

  /**
   * 虚拟结算单标识
   */
  @TableField("pInventedFlag")
  private String pInventedFlag;

  /**
   * 包含结算单开票明细标识
   */
  @TableField("pIncloudInvoiceDetailFlag")
  private String pIncloudInvoiceDetailFlag;

  /**
   * 审核状态
   */
  @TableField("approveStatus")
  private String approveStatus;

  /**
   * 付款状态
   */
  @TableField("paymentStatus")
  private String paymentStatus;

  /**
   * 核销状态
   */
  @TableField("verifyStatus")
  private String verifyStatus;

  /**
   * 价内折扣总金额（含税）
   */
  @TableField("innerDiscountWithTax")
  private BigDecimal innerDiscountWithTax;

  /**
   * 价内折扣总金额（不含税）
   */
  @TableField("innerDiscountWithoutTax")
  private BigDecimal innerDiscountWithoutTax;

  /**
   * 价外折扣总金额（含税）
   */
  @TableField("outterDiscountWithTax")
  private BigDecimal outterDiscountWithTax;

  /**
   * 价外折扣不含税总金额（含税）
   */
  @TableField("outterDiscountWithoutTax")
  private BigDecimal outterDiscountWithoutTax;

  /**
   * 合同号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 开票状态
   */
  @TableField("invoiceStatus")
  private String invoiceStatus;

  /**
   * 销方客户类型
   */
  @TableField("sCustomerType")
  private String sCustomerType;

  /**
   * 销方销售组编码
   */
  @TableField("sSalesGroupCode")
  private String sSalesGroupCode;

  /**
   * 销方销售组名称
   */
  @TableField("sSalesGroupName")
  private String sSalesGroupName;

  /**
   * 销方对账状态
   */
  @TableField("pSellerReconStatus")
  private String pSellerReconStatus;

  /**
   * 销方客户组
   */
  @TableField("sCustomerGroup")
  private String sCustomerGroup;

  /**
   * 自定义字段
   */
  private String attribute1;

  /**
   * 自定义字段
   */
  private String attribute2;

  /**
   * 自定义字段
   */
  private String attribute3;

  /**
   * 自定义字段
   */
  private String attribute4;

  /**
   * 自定义字段
   */
  private String attribute5;

  /**
   * 自定义字段
   */
  private String attribute6;

  /**
   * 自定义字段
   */
  private String attribute7;

  /**
   * 自定义字段
   */
  private String attribute8;

  /**
   * 结算单单据来源
   */
  @TableField("pSourceFrom")
  private String pSourceFrom;

  /**
   * 往期结算单列表
   */
  @TableField("previousSettlementList")
  private String previousSettlementList;

  /**
   * 销方销售组织编码
   */
  @TableField("sSalesOrganizationCode")
  private String sSalesOrganizationCode;

  /**
   * 销方销售组织名称
   */
  @TableField("sSalesOrganizationName")
  private String sSalesOrganizationName;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("belongTenant", belongTenant);
      map.put("collectionAccount", collectionAccount);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("settlementNo", settlementNo);
      map.put("documentType", documentType);
      map.put("documentStatus", documentStatus);
      map.put("versionNo", versionNo);
      map.put("purchaseBusinessTypeNo", purchaseBusinessTypeNo);
      map.put("purchaseBusinessTypeName", purchaseBusinessTypeName);
      map.put("purchaseCity", purchaseCity);
      map.put("businessUnit", businessUnit);
      map.put("regionCode", regionCode);
      map.put("regionName", regionName);
      map.put("purchaseStoreCode", purchaseStoreCode);
      map.put("purchaseStoreGLN", purchaseStoreGLN);
      map.put("purchaseStoreName", purchaseStoreName);
      map.put("purchaseStorageCenterCode", purchaseStorageCenterCode);
      map.put("purchaseStorageCenterName", purchaseStorageCenterName);
      map.put("purchaseCompanyTaxNo", purchaseCompanyTaxNo);
      map.put("purchaseCompanyCode", purchaseCompanyCode);
      map.put("purchaseCompanyName", purchaseCompanyName);
      map.put("sellerType", sellerType);
      map.put("sellerCompanyTaxNo", sellerCompanyTaxNo);
      map.put("sellerCompanyCode", sellerCompanyCode);
      map.put("sellerCompanyName", sellerCompanyName);
      map.put("sellerCode", sellerCode);
      map.put("sellerName", sellerName);
      map.put("debitAmt", debitAmt);
      map.put("invoicedDeductionAmt", invoicedDeductionAmt);
      map.put("payableAmtWithTax", payableAmtWithTax);
      map.put("totalAmtWithTax", totalAmtWithTax);
      map.put("totalAmtWithoutTax", totalAmtWithoutTax);
      map.put("sujestInvoicedAmtWithTax", sujestInvoicedAmtWithTax);
      map.put("sujestInvoicedAmtWithoutTax", sujestInvoicedAmtWithoutTax);
      map.put("sujestInvoicedTax", sujestInvoicedTax);
      map.put("invoicedAmtWithTax", invoicedAmtWithTax);
      map.put("settlementDate", BocpGenUtils.toTimestamp(settlementDate));
      map.put("creationDate", BocpGenUtils.toTimestamp(creationDate));
      map.put("approveDate", BocpGenUtils.toTimestamp(approveDate));
      map.put("createdBy", createdBy);
      map.put("approvedBy", approvedBy);
      map.put("invoiceConfirmBy", invoiceConfirmBy);
      map.put("invoiceConfirmTime", BocpGenUtils.toTimestamp(invoiceConfirmTime));
      map.put("invoiceCreatedBy", invoiceCreatedBy);
      map.put("invoiceCreatedTime", BocpGenUtils.toTimestamp(invoiceCreatedTime));
      map.put("logisticsMode", logisticsMode);
      map.put("currencyCode", currencyCode);
      map.put("currency", currency);
      map.put("settlementCode", settlementCode);
      map.put("settlementName", settlementName);
      map.put("payCondtCode", payCondtCode);
      map.put("payCondtName", payCondtName);
      map.put("schedulePayDate", BocpGenUtils.toTimestamp(schedulePayDate));
      map.put("payDate", BocpGenUtils.toTimestamp(payDate));
      map.put("payAmtWithTax", payAmtWithTax);
      map.put("remark", remark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("latest", latest);
      map.put("srcids", srcids);
      map.put("md5", md5);
      map.put("businessId", businessId);
      map.put("priceStatus", priceStatus);
      map.put("pBusinessId", pBusinessId);
      map.put("pSellerInvoiceStatus", pSellerInvoiceStatus);
      map.put("pCancelFlag", pCancelFlag);
      map.put("pInventedFlag", pInventedFlag);
      map.put("pIncloudInvoiceDetailFlag", pIncloudInvoiceDetailFlag);
      map.put("approveStatus", approveStatus);
      map.put("paymentStatus", paymentStatus);
      map.put("verifyStatus", verifyStatus);
      map.put("innerDiscountWithTax", innerDiscountWithTax);
      map.put("innerDiscountWithoutTax", innerDiscountWithoutTax);
      map.put("outterDiscountWithTax", outterDiscountWithTax);
      map.put("outterDiscountWithoutTax", outterDiscountWithoutTax);
      map.put("contractNo", contractNo);
      map.put("invoiceStatus", invoiceStatus);
      map.put("sCustomerType", sCustomerType);
      map.put("sSalesGroupCode", sSalesGroupCode);
      map.put("sSalesGroupName", sSalesGroupName);
      map.put("pSellerReconStatus", pSellerReconStatus);
      map.put("sCustomerGroup", sCustomerGroup);
      map.put("attribute1", attribute1);
      map.put("attribute2", attribute2);
      map.put("attribute3", attribute3);
      map.put("attribute4", attribute4);
      map.put("attribute5", attribute5);
      map.put("attribute6", attribute6);
      map.put("attribute7", attribute7);
      map.put("attribute8", attribute8);
      map.put("pSourceFrom", pSourceFrom);
      map.put("previousSettlementList", previousSettlementList);
      map.put("sSalesOrganizationCode", sSalesOrganizationCode);
      map.put("sSalesOrganizationName", sSalesOrganizationName);

      return map;
  }

  public static SettlementBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SettlementBill entity = new SettlementBill();
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementNo")) {
      Object obj = map.get("settlementNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentStatus")) {
      Object obj = map.get("documentStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCity")) {
      Object obj = map.get("purchaseCity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessUnit")) {
      Object obj = map.get("businessUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStorageCenterCode")) {
      Object obj = map.get("purchaseStorageCenterCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStorageCenterCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStorageCenterName")) {
      Object obj = map.get("purchaseStorageCenterName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStorageCenterName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerType")) {
      Object obj = map.get("sellerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("debitAmt")) {
      Object obj = map.get("debitAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDebitAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDebitAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDebitAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDebitAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDebitAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoicedDeductionAmt")) {
      Object obj = map.get("invoicedDeductionAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoicedDeductionAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoicedDeductionAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoicedDeductionAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoicedDeductionAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoicedDeductionAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("payableAmtWithTax")) {
      Object obj = map.get("payableAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayableAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayableAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayableAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayableAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayableAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmtWithTax")) {
      Object obj = map.get("totalAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sujestInvoicedAmtWithTax")) {
      Object obj = map.get("sujestInvoicedAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSujestInvoicedAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSujestInvoicedAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSujestInvoicedAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSujestInvoicedAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSujestInvoicedAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sujestInvoicedAmtWithoutTax")) {
      Object obj = map.get("sujestInvoicedAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSujestInvoicedAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSujestInvoicedAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSujestInvoicedAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSujestInvoicedAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSujestInvoicedAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sujestInvoicedTax")) {
      Object obj = map.get("sujestInvoicedTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSujestInvoicedTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSujestInvoicedTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSujestInvoicedTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSujestInvoicedTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSujestInvoicedTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoicedAmtWithTax")) {
      Object obj = map.get("invoicedAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoicedAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoicedAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoicedAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoicedAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoicedAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlementDate")) {
      Object obj = map.get("settlementDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSettlementDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementDate(null);
      }
    }
    if(map.containsKey("creationDate")) {
      Object obj = map.get("creationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreationDate(null);
      }
    }
    if(map.containsKey("approveDate")) {
      Object obj = map.get("approveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApproveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApproveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApproveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApproveDate(null);
      }
    }
    if(map.containsKey("createdBy")) {
      Object obj = map.get("createdBy");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreatedBy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approvedBy")) {
      Object obj = map.get("approvedBy");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApprovedBy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceConfirmBy")) {
      Object obj = map.get("invoiceConfirmBy");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceConfirmBy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceConfirmTime")) {
      Object obj = map.get("invoiceConfirmTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceConfirmTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setInvoiceConfirmTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceConfirmTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceConfirmTime(null);
      }
    }
    if(map.containsKey("invoiceCreatedBy")) {
      Object obj = map.get("invoiceCreatedBy");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCreatedBy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCreatedTime")) {
      Object obj = map.get("invoiceCreatedTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceCreatedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setInvoiceCreatedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceCreatedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceCreatedTime(null);
      }
    }
    if(map.containsKey("logisticsMode")) {
      Object obj = map.get("logisticsMode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currencyCode")) {
      Object obj = map.get("currencyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrencyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementCode")) {
      Object obj = map.get("settlementCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementName")) {
      Object obj = map.get("settlementName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payCondtCode")) {
      Object obj = map.get("payCondtCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayCondtCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payCondtName")) {
      Object obj = map.get("payCondtName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayCondtName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("schedulePayDate")) {
      Object obj = map.get("schedulePayDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSchedulePayDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSchedulePayDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSchedulePayDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSchedulePayDate(null);
      }
    }
    if(map.containsKey("payDate")) {
      Object obj = map.get("payDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPayDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPayDate(null);
      }
    }
    if(map.containsKey("payAmtWithTax")) {
      Object obj = map.get("payAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSrcids((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("md5")) {
      Object obj = map.get("md5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMd5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPriceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPriceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPriceStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSellerInvoiceStatus")) {
      Object obj = map.get("pSellerInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSellerInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pCancelFlag")) {
      Object obj = map.get("pCancelFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPCancelFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pInventedFlag")) {
      Object obj = map.get("pInventedFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPInventedFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pIncloudInvoiceDetailFlag")) {
      Object obj = map.get("pIncloudInvoiceDetailFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPIncloudInvoiceDetailFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approveStatus")) {
      Object obj = map.get("approveStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApproveStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentStatus")) {
      Object obj = map.get("paymentStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verifyStatus")) {
      Object obj = map.get("verifyStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerifyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountWithTax")) {
      Object obj = map.get("innerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInnerDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountWithoutTax")) {
      Object obj = map.get("innerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInnerDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountWithTax")) {
      Object obj = map.get("outterDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountWithoutTax")) {
      Object obj = map.get("outterDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerType")) {
      Object obj = map.get("sCustomerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupCode")) {
      Object obj = map.get("sSalesGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupName")) {
      Object obj = map.get("sSalesGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSellerReconStatus")) {
      Object obj = map.get("pSellerReconStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSellerReconStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroup")) {
      Object obj = map.get("sCustomerGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute1")) {
      Object obj = map.get("attribute1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute2")) {
      Object obj = map.get("attribute2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute3")) {
      Object obj = map.get("attribute3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute4")) {
      Object obj = map.get("attribute4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute5")) {
      Object obj = map.get("attribute5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute6")) {
      Object obj = map.get("attribute6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute7")) {
      Object obj = map.get("attribute7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute8")) {
      Object obj = map.get("attribute8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSourceFrom")) {
      Object obj = map.get("pSourceFrom");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSourceFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("previousSettlementList")) {
      Object obj = map.get("previousSettlementList");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPreviousSettlementList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationCode")) {
      Object obj = map.get("sSalesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationName")) {
      Object obj = map.get("sSalesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrganizationName((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementNo")) {
      Object obj = map.get("settlementNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentStatus")) {
      Object obj = map.get("documentStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseBusinessTypeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseBusinessTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCity")) {
      Object obj = map.get("purchaseCity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessUnit")) {
      Object obj = map.get("businessUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreGLN((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStorageCenterCode")) {
      Object obj = map.get("purchaseStorageCenterCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStorageCenterCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStorageCenterName")) {
      Object obj = map.get("purchaseStorageCenterName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStorageCenterName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerType")) {
      Object obj = map.get("sellerType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("debitAmt")) {
      Object obj = map.get("debitAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDebitAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDebitAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDebitAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDebitAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDebitAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoicedDeductionAmt")) {
      Object obj = map.get("invoicedDeductionAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoicedDeductionAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoicedDeductionAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoicedDeductionAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoicedDeductionAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoicedDeductionAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("payableAmtWithTax")) {
      Object obj = map.get("payableAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayableAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayableAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayableAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayableAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayableAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmtWithTax")) {
      Object obj = map.get("totalAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sujestInvoicedAmtWithTax")) {
      Object obj = map.get("sujestInvoicedAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSujestInvoicedAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSujestInvoicedAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSujestInvoicedAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSujestInvoicedAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSujestInvoicedAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sujestInvoicedAmtWithoutTax")) {
      Object obj = map.get("sujestInvoicedAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSujestInvoicedAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSujestInvoicedAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSujestInvoicedAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSujestInvoicedAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSujestInvoicedAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sujestInvoicedTax")) {
      Object obj = map.get("sujestInvoicedTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSujestInvoicedTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSujestInvoicedTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSujestInvoicedTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSujestInvoicedTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSujestInvoicedTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoicedAmtWithTax")) {
      Object obj = map.get("invoicedAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoicedAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoicedAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoicedAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoicedAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoicedAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("settlementDate")) {
      Object obj = map.get("settlementDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSettlementDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSettlementDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettlementDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSettlementDate(null);
      }
    }
    if(map.containsKey("creationDate")) {
      Object obj = map.get("creationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreationDate(null);
      }
    }
    if(map.containsKey("approveDate")) {
      Object obj = map.get("approveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setApproveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setApproveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setApproveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setApproveDate(null);
      }
    }
    if(map.containsKey("createdBy")) {
      Object obj = map.get("createdBy");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreatedBy((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("approvedBy")) {
      Object obj = map.get("approvedBy");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApprovedBy((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceConfirmBy")) {
      Object obj = map.get("invoiceConfirmBy");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceConfirmBy((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceConfirmTime")) {
      Object obj = map.get("invoiceConfirmTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceConfirmTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setInvoiceConfirmTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceConfirmTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setInvoiceConfirmTime(null);
      }
    }
    if(map.containsKey("invoiceCreatedBy")) {
      Object obj = map.get("invoiceCreatedBy");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCreatedBy((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceCreatedTime")) {
      Object obj = map.get("invoiceCreatedTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceCreatedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setInvoiceCreatedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceCreatedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setInvoiceCreatedTime(null);
      }
    }
    if(map.containsKey("logisticsMode")) {
      Object obj = map.get("logisticsMode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticsMode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("currencyCode")) {
      Object obj = map.get("currencyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCurrencyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCurrency((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementCode")) {
      Object obj = map.get("settlementCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementName")) {
      Object obj = map.get("settlementName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payCondtCode")) {
      Object obj = map.get("payCondtCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayCondtCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payCondtName")) {
      Object obj = map.get("payCondtName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayCondtName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("schedulePayDate")) {
      Object obj = map.get("schedulePayDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSchedulePayDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSchedulePayDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSchedulePayDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSchedulePayDate(null);
      }
    }
    if(map.containsKey("payDate")) {
      Object obj = map.get("payDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPayDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPayDate(null);
      }
    }
    if(map.containsKey("payAmtWithTax")) {
      Object obj = map.get("payAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSrcids((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("md5")) {
      Object obj = map.get("md5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMd5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBusinessId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPriceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPriceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPriceStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pSellerInvoiceStatus")) {
      Object obj = map.get("pSellerInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSellerInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pCancelFlag")) {
      Object obj = map.get("pCancelFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPCancelFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pInventedFlag")) {
      Object obj = map.get("pInventedFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPInventedFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pIncloudInvoiceDetailFlag")) {
      Object obj = map.get("pIncloudInvoiceDetailFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPIncloudInvoiceDetailFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("approveStatus")) {
      Object obj = map.get("approveStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApproveStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentStatus")) {
      Object obj = map.get("paymentStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verifyStatus")) {
      Object obj = map.get("verifyStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerifyStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("innerDiscountWithTax")) {
      Object obj = map.get("innerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInnerDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("innerDiscountWithoutTax")) {
      Object obj = map.get("innerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInnerDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outterDiscountWithTax")) {
      Object obj = map.get("outterDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOutterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOutterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOutterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOutterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outterDiscountWithoutTax")) {
      Object obj = map.get("outterDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOutterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOutterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOutterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOutterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomerType")) {
      Object obj = map.get("sCustomerType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesGroupCode")) {
      Object obj = map.get("sSalesGroupCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesGroupCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesGroupName")) {
      Object obj = map.get("sSalesGroupName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesGroupName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pSellerReconStatus")) {
      Object obj = map.get("pSellerReconStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSellerReconStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomerGroup")) {
      Object obj = map.get("sCustomerGroup");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute1")) {
      Object obj = map.get("attribute1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute2")) {
      Object obj = map.get("attribute2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute3")) {
      Object obj = map.get("attribute3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute4")) {
      Object obj = map.get("attribute4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute5")) {
      Object obj = map.get("attribute5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute6")) {
      Object obj = map.get("attribute6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute7")) {
      Object obj = map.get("attribute7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute8")) {
      Object obj = map.get("attribute8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pSourceFrom")) {
      Object obj = map.get("pSourceFrom");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSourceFrom((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("previousSettlementList")) {
      Object obj = map.get("previousSettlementList");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPreviousSettlementList((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesOrganizationCode")) {
      Object obj = map.get("sSalesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesOrganizationCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesOrganizationName")) {
      Object obj = map.get("sSalesOrganizationName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesOrganizationName((String)obj);
        }
      } else {
      }
    }
  }
}
