package com.xforceplus.ultraman.app.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-09-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ReturnToVendorDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 行编号
   */
  @TableField("lineNo")
  private String lineNo;

  /**
   * 行创建日期
   */
  @TableField("lineCreateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lineCreateDate;

  /**
   * 行更新日期
   */
  @TableField("lineUpdateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lineUpdateDate;

  /**
   * 商品名称
   */
  @TableField("itemDesc")
  private String itemDesc;

  /**
   * 商品编码
   */
  @TableField("itemCode")
  private String itemCode;

  /**
   * 商品条码
   */
  private String barcode;

  /**
   * 商品子编码
   */
  @TableField("itemSubCode")
  private String itemSubCode;

  /**
   * 品牌
   */
  private String brand;

  /**
   * 规格型号
   */
  private String standards;

  /**
   * 颜色
   */
  private String color;

  /**
   * 尺寸
   */
  private String size;

  /**
   * 产地
   */
  @TableField("produceArea")
  private String produceArea;

  /**
   * 保质期
   */
  @TableField("guaranteePeriod")
  private String guaranteePeriod;

  /**
   * 净重量
   */
  @TableField("netWeight")
  private String netWeight;

  /**
   * 总重量
   */
  @TableField("totalWeight")
  private String totalWeight;

  /**
   * 单据单位
   */
  private String unit;

  /**
   * 单价（不含税）
   */
  @TableField("unitPriceWithoutTax")
  private BigDecimal unitPriceWithoutTax;

  /**
   * 单价（含税）
   */
  @TableField("unitPriceWithTax")
  private BigDecimal unitPriceWithTax;

  /**
   * 供应商商品编码
   */
  @TableField("cusItemCode")
  private String cusItemCode;

  /**
   * 批量包装规格
   */
  @TableField("packageSize")
  private String packageSize;

  /**
   * 批量包装数量
   */
  @TableField("packageQty")
  private BigDecimal packageQty;

  /**
   * 批量包装单位
   */
  @TableField("packageUnit")
  private String packageUnit;

  /**
   * 税收分类
   */
  @TableField("taxType")
  private String taxType;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 折扣率
   */
  @TableField("discountRate")
  private BigDecimal discountRate;

  /**
   * 折扣金额（含税）
   */
  @TableField("discountAmt")
  private BigDecimal discountAmt;

  /**
   * 退货商品数量
   */
  @TableField("rtvUnitQty")
  private BigDecimal rtvUnitQty;

  /**
   * 退货原因类型
   */
  @TableField("rtvReasonType")
  private String rtvReasonType;

  /**
   * 退货原因
   */
  @TableField("rtvReason")
  private String rtvReason;

  /**
   * 备注
   */
  private String remark;

  /**
   * 模版变量Id
   */
  private String vvariableid;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 金额（不含税）
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 金额（含税）
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 税收分类编码
   */
  @TableField("goodsTaxNo")
  private String goodsTaxNo;

  /**
   * 批量包装单价（不含税）
   */
  @TableField("packageUnitPriceWithoutTax")
  private BigDecimal packageUnitPriceWithoutTax;

  /**
   * 批量包装单价（含税）
   */
  @TableField("packageUnitPriceWithTax")
  private BigDecimal packageUnitPriceWithTax;

  /**
   * 折扣金额（不含税）
   */
  @TableField("discountAmtWithoutTax")
  private BigDecimal discountAmtWithoutTax;

  /**
   * 销方商品名称
   */
  @TableField("sItemDesc")
  private String sItemDesc;

  /**
   * 销方商品编码
   */
  @TableField("sItemCode")
  private String sItemCode;

  /**
   * 销方商品条码
   */
  @TableField("sBarcode")
  private String sBarcode;

  /**
   * 销方商品子编码
   */
  @TableField("sItemSubCode")
  private String sItemSubCode;

  /**
   * 销方品牌
   */
  @TableField("sBrand")
  private String sBrand;

  /**
   * 销方规格
   */
  @TableField("sStandards")
  private String sStandards;

  /**
   * 销方颜色
   */
  @TableField("sColor")
  private String sColor;

  /**
   * 销方尺寸
   */
  @TableField("sSize")
  private String sSize;

  /**
   * 销方产地
   */
  @TableField("sProduceArea")
  private String sProduceArea;

  /**
   * 销方保质期
   */
  @TableField("sGuaranteePeriod")
  private String sGuaranteePeriod;

  /**
   * 销方重量单位
   */
  @TableField("sWeightUnit")
  private String sWeightUnit;

  /**
   * 销方总重量
   */
  @TableField("sTotalWeight")
  private String sTotalWeight;

  /**
   * 销方批量包装规格
   */
  @TableField("sPackageSize")
  private String sPackageSize;

  /**
   * 销方批量包装数量
   */
  @TableField("sPackageQty")
  private BigDecimal sPackageQty;

  /**
   * 销方批量包装单位
   */
  @TableField("sPackageUnit")
  private String sPackageUnit;

  /**
   * 销方批量包装单价（不含税）
   */
  @TableField("sPackageUnitPriceWithoutTax")
  private BigDecimal sPackageUnitPriceWithoutTax;

  /**
   * 销方批量包装单价（含税）
   */
  @TableField("sPackageUnitPriceWithTax")
  private BigDecimal sPackageUnitPriceWithTax;

  /**
   * 销方批量包装最小起订量
   */
  @TableField("sPackageMinOrdQty")
  private BigDecimal sPackageMinOrdQty;

  /**
   * 单位转换规则（对象数组）
   */
  @TableField("sUnitRules")
  private String sUnitRules;

  /**
   * 销方单据单位单位
   */
  @TableField("sUnit")
  private String sUnit;

  /**
   * 销方单据单位数量
   */
  @TableField("sQty")
  private BigDecimal sQty;

  /**
   * 销方单价（不含税）
   */
  @TableField("sUnitPriceWithoutTax")
  private BigDecimal sUnitPriceWithoutTax;

  /**
   * 销方单价（含税）
   */
  @TableField("sUnitPriceWithTax")
  private BigDecimal sUnitPriceWithTax;

  /**
   * 销方价格上限
   */
  @TableField("sUnitPriceMax")
  private BigDecimal sUnitPriceMax;

  /**
   * 销方价格下限
   */
  @TableField("sUnitPriceMin")
  private BigDecimal sUnitPriceMin;

  /**
   * 销方金额（含税）
   */
  @TableField("sAmountWithTax")
  private BigDecimal sAmountWithTax;

  /**
   * 销方金额（不含税）
   */
  @TableField("sAmountWithoutTax")
  private BigDecimal sAmountWithoutTax;

  /**
   * 销方税收分类
   */
  @TableField("sTaxType")
  private String sTaxType;

  /**
   * 销方税率
   */
  @TableField("sTaxRate")
  private BigDecimal sTaxRate;

  /**
   * 销方折扣率
   */
  @TableField("sDiscountRate")
  private BigDecimal sDiscountRate;

  /**
   * 销方是否促销
   */
  @TableField("sPromtFlag")
  private String sPromtFlag;

  /**
   * 销方是否赠品
   */
  @TableField("sFreeFlag")
  private String sFreeFlag;

  /**
   * 销方是否组套商品
   */
  @TableField("sSuitFlag")
  private String sSuitFlag;

  /**
   * 销方组套商品（数组）
   */
  @TableField("sSuitInfo")
  private String sSuitInfo;

  /**
   * 销方是否新老品
   */
  @TableField("sNewOldFlag")
  private String sNewOldFlag;

  /**
   * 销方新老商品（数组）
   */
  @TableField("sNewOldInfo")
  private String sNewOldInfo;

  /**
   * 销方最低起订量
   */
  @TableField("sMinOrdQty")
  private BigDecimal sMinOrdQty;

  /**
   * 品类编码
   */
  @TableField("categoryCode")
  private String categoryCode;

  /**
   * 品类名称
   */
  @TableField("categoryDesc")
  private String categoryDesc;

  /**
   * 品类编码
   */
  @TableField("sCategoryCode")
  private String sCategoryCode;

  /**
   * 品类名称
   */
  @TableField("sCategoryDesc")
  private String sCategoryDesc;

  /**
   * 客户商品单位
   */
  @TableField("sCustomUnit")
  private String sCustomUnit;


  /**
   * 对一关联关系 关联对象 returnToVendor
   */
    private Long headIdId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("lineNo", lineNo);
      map.put("lineCreateDate", BocpGenUtils.toTimestamp(lineCreateDate));
      map.put("lineUpdateDate", BocpGenUtils.toTimestamp(lineUpdateDate));
      map.put("itemDesc", itemDesc);
      map.put("itemCode", itemCode);
      map.put("barcode", barcode);
      map.put("itemSubCode", itemSubCode);
      map.put("brand", brand);
      map.put("standards", standards);
      map.put("color", color);
      map.put("size", size);
      map.put("produceArea", produceArea);
      map.put("guaranteePeriod", guaranteePeriod);
      map.put("netWeight", netWeight);
      map.put("totalWeight", totalWeight);
      map.put("unit", unit);
      map.put("unitPriceWithoutTax", unitPriceWithoutTax);
      map.put("unitPriceWithTax", unitPriceWithTax);
      map.put("cusItemCode", cusItemCode);
      map.put("packageSize", packageSize);
      map.put("packageQty", packageQty);
      map.put("packageUnit", packageUnit);
      map.put("taxType", taxType);
      map.put("taxRate", taxRate);
      map.put("discountRate", discountRate);
      map.put("discountAmt", discountAmt);
      map.put("rtvUnitQty", rtvUnitQty);
      map.put("rtvReasonType", rtvReasonType);
      map.put("rtvReason", rtvReason);
      map.put("remark", remark);
      map.put("vvariableid", vvariableid);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("amountWithTax", amountWithTax);
      map.put("goodsTaxNo", goodsTaxNo);
      map.put("packageUnitPriceWithoutTax", packageUnitPriceWithoutTax);
      map.put("packageUnitPriceWithTax", packageUnitPriceWithTax);
      map.put("discountAmtWithoutTax", discountAmtWithoutTax);
      map.put("sItemDesc", sItemDesc);
      map.put("sItemCode", sItemCode);
      map.put("sBarcode", sBarcode);
      map.put("sItemSubCode", sItemSubCode);
      map.put("sBrand", sBrand);
      map.put("sStandards", sStandards);
      map.put("sColor", sColor);
      map.put("sSize", sSize);
      map.put("sProduceArea", sProduceArea);
      map.put("sGuaranteePeriod", sGuaranteePeriod);
      map.put("sWeightUnit", sWeightUnit);
      map.put("sTotalWeight", sTotalWeight);
      map.put("sPackageSize", sPackageSize);
      map.put("sPackageQty", sPackageQty);
      map.put("sPackageUnit", sPackageUnit);
      map.put("sPackageUnitPriceWithoutTax", sPackageUnitPriceWithoutTax);
      map.put("sPackageUnitPriceWithTax", sPackageUnitPriceWithTax);
      map.put("sPackageMinOrdQty", sPackageMinOrdQty);
      map.put("sUnitRules", sUnitRules);
      map.put("sUnit", sUnit);
      map.put("sQty", sQty);
      map.put("sUnitPriceWithoutTax", sUnitPriceWithoutTax);
      map.put("sUnitPriceWithTax", sUnitPriceWithTax);
      map.put("sUnitPriceMax", sUnitPriceMax);
      map.put("sUnitPriceMin", sUnitPriceMin);
      map.put("sAmountWithTax", sAmountWithTax);
      map.put("sAmountWithoutTax", sAmountWithoutTax);
      map.put("sTaxType", sTaxType);
      map.put("sTaxRate", sTaxRate);
      map.put("sDiscountRate", sDiscountRate);
      map.put("sPromtFlag", sPromtFlag);
      map.put("sFreeFlag", sFreeFlag);
      map.put("sSuitFlag", sSuitFlag);
      map.put("sSuitInfo", sSuitInfo);
      map.put("sNewOldFlag", sNewOldFlag);
      map.put("sNewOldInfo", sNewOldInfo);
      map.put("sMinOrdQty", sMinOrdQty);
      map.put("categoryCode", categoryCode);
      map.put("categoryDesc", categoryDesc);
      map.put("sCategoryCode", sCategoryCode);
      map.put("sCategoryDesc", sCategoryDesc);
      map.put("sCustomUnit", sCustomUnit);

       map.put("headId.id", headIdId);
      return map;
  }

  public static ReturnToVendorDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ReturnToVendorDetail entity = new ReturnToVendorDetail();
    if(map.containsKey("lineNo")) {
      Object obj = map.get("lineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lineCreateDate")) {
      Object obj = map.get("lineCreateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLineCreateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setLineCreateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLineCreateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLineCreateDate(null);
      }
    }
    if(map.containsKey("lineUpdateDate")) {
      Object obj = map.get("lineUpdateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLineUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setLineUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLineUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLineUpdateDate(null);
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSubCode")) {
      Object obj = map.get("itemSubCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("color")) {
      Object obj = map.get("color");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("size")) {
      Object obj = map.get("size");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("produceArea")) {
      Object obj = map.get("produceArea");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProduceArea((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("guaranteePeriod")) {
      Object obj = map.get("guaranteePeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGuaranteePeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netWeight")) {
      Object obj = map.get("netWeight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNetWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalWeight")) {
      Object obj = map.get("totalWeight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTotalWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithTax")) {
      Object obj = map.get("unitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cusItemCode")) {
      Object obj = map.get("cusItemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCusItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageSize")) {
      Object obj = map.get("packageSize");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageQty")) {
      Object obj = map.get("packageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("packageUnit")) {
      Object obj = map.get("packageUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxType")) {
      Object obj = map.get("taxType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountAmt")) {
      Object obj = map.get("discountAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rtvUnitQty")) {
      Object obj = map.get("rtvUnitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRtvUnitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRtvUnitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRtvUnitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRtvUnitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRtvUnitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rtvReasonType")) {
      Object obj = map.get("rtvReasonType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRtvReasonType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rtvReason")) {
      Object obj = map.get("rtvReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRtvReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVvariableid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageUnitPriceWithoutTax")) {
      Object obj = map.get("packageUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("packageUnitPriceWithTax")) {
      Object obj = map.get("packageUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountAmtWithoutTax")) {
      Object obj = map.get("discountAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sItemDesc")) {
      Object obj = map.get("sItemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sItemCode")) {
      Object obj = map.get("sItemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBarcode")) {
      Object obj = map.get("sBarcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sItemSubCode")) {
      Object obj = map.get("sItemSubCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBrand")) {
      Object obj = map.get("sBrand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sStandards")) {
      Object obj = map.get("sStandards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sColor")) {
      Object obj = map.get("sColor");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSize")) {
      Object obj = map.get("sSize");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sProduceArea")) {
      Object obj = map.get("sProduceArea");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSProduceArea((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sGuaranteePeriod")) {
      Object obj = map.get("sGuaranteePeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSGuaranteePeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sWeightUnit")) {
      Object obj = map.get("sWeightUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSWeightUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sTotalWeight")) {
      Object obj = map.get("sTotalWeight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSTotalWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPackageSize")) {
      Object obj = map.get("sPackageSize");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPackageSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPackageQty")) {
      Object obj = map.get("sPackageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sPackageUnit")) {
      Object obj = map.get("sPackageUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPackageUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPackageUnitPriceWithoutTax")) {
      Object obj = map.get("sPackageUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSPackageUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSPackageUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sPackageUnitPriceWithTax")) {
      Object obj = map.get("sPackageUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSPackageUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSPackageUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSPackageUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSPackageUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSPackageUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sPackageMinOrdQty")) {
      Object obj = map.get("sPackageMinOrdQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSPackageMinOrdQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSPackageMinOrdQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSPackageMinOrdQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSPackageMinOrdQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSPackageMinOrdQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sUnitRules")) {
      Object obj = map.get("sUnitRules");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSUnitRules((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sUnit")) {
      Object obj = map.get("sUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sQty")) {
      Object obj = map.get("sQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sUnitPriceWithoutTax")) {
      Object obj = map.get("sUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sUnitPriceWithTax")) {
      Object obj = map.get("sUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sUnitPriceMax")) {
      Object obj = map.get("sUnitPriceMax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSUnitPriceMax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSUnitPriceMax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSUnitPriceMax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSUnitPriceMax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSUnitPriceMax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sUnitPriceMin")) {
      Object obj = map.get("sUnitPriceMin");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSUnitPriceMin((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSUnitPriceMin(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSUnitPriceMin(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSUnitPriceMin(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSUnitPriceMin(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sAmountWithTax")) {
      Object obj = map.get("sAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sAmountWithoutTax")) {
      Object obj = map.get("sAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sTaxType")) {
      Object obj = map.get("sTaxType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSTaxType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sTaxRate")) {
      Object obj = map.get("sTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sDiscountRate")) {
      Object obj = map.get("sDiscountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sPromtFlag")) {
      Object obj = map.get("sPromtFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPromtFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sFreeFlag")) {
      Object obj = map.get("sFreeFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSFreeFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSuitFlag")) {
      Object obj = map.get("sSuitFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSuitFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSuitInfo")) {
      Object obj = map.get("sSuitInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSuitInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sNewOldFlag")) {
      Object obj = map.get("sNewOldFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSNewOldFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sNewOldInfo")) {
      Object obj = map.get("sNewOldInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSNewOldInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sMinOrdQty")) {
      Object obj = map.get("sMinOrdQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSMinOrdQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSMinOrdQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSMinOrdQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSMinOrdQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSMinOrdQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryDesc")) {
      Object obj = map.get("categoryDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCategoryCode")) {
      Object obj = map.get("sCategoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCategoryDesc")) {
      Object obj = map.get("sCategoryDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCategoryDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomUnit")) {
      Object obj = map.get("sCustomUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomUnit((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("headId.id")) {
        Object obj = map.get("headId.id");
      if(obj instanceof Long) {
        entity.setHeadIdId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setHeadIdId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("lineNo")) {
      Object obj = map.get("lineNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lineCreateDate")) {
      Object obj = map.get("lineCreateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLineCreateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setLineCreateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLineCreateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setLineCreateDate(null);
      }
    }
    if(map.containsKey("lineUpdateDate")) {
      Object obj = map.get("lineUpdateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLineUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setLineUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLineUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setLineUpdateDate(null);
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBarcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemSubCode")) {
      Object obj = map.get("itemSubCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemSubCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStandards((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("color")) {
      Object obj = map.get("color");
      if(obj != null) {
        if(obj instanceof String) {
          this.setColor((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("size")) {
      Object obj = map.get("size");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSize((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("produceArea")) {
      Object obj = map.get("produceArea");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProduceArea((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("guaranteePeriod")) {
      Object obj = map.get("guaranteePeriod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGuaranteePeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("netWeight")) {
      Object obj = map.get("netWeight");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNetWeight((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("totalWeight")) {
      Object obj = map.get("totalWeight");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTotalWeight((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unitPriceWithTax")) {
      Object obj = map.get("unitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("cusItemCode")) {
      Object obj = map.get("cusItemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCusItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("packageSize")) {
      Object obj = map.get("packageSize");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPackageSize((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("packageQty")) {
      Object obj = map.get("packageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("packageUnit")) {
      Object obj = map.get("packageUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPackageUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxType")) {
      Object obj = map.get("taxType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discountAmt")) {
      Object obj = map.get("discountAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("rtvUnitQty")) {
      Object obj = map.get("rtvUnitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRtvUnitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRtvUnitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRtvUnitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRtvUnitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRtvUnitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("rtvReasonType")) {
      Object obj = map.get("rtvReasonType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRtvReasonType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rtvReason")) {
      Object obj = map.get("rtvReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRtvReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVvariableid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("packageUnitPriceWithoutTax")) {
      Object obj = map.get("packageUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPackageUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPackageUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPackageUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPackageUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPackageUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("packageUnitPriceWithTax")) {
      Object obj = map.get("packageUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPackageUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPackageUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPackageUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPackageUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPackageUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discountAmtWithoutTax")) {
      Object obj = map.get("discountAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sItemDesc")) {
      Object obj = map.get("sItemDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSItemDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sItemCode")) {
      Object obj = map.get("sItemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sBarcode")) {
      Object obj = map.get("sBarcode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBarcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sItemSubCode")) {
      Object obj = map.get("sItemSubCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSItemSubCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sBrand")) {
      Object obj = map.get("sBrand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sStandards")) {
      Object obj = map.get("sStandards");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSStandards((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sColor")) {
      Object obj = map.get("sColor");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSColor((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSize")) {
      Object obj = map.get("sSize");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSize((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sProduceArea")) {
      Object obj = map.get("sProduceArea");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSProduceArea((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sGuaranteePeriod")) {
      Object obj = map.get("sGuaranteePeriod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSGuaranteePeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sWeightUnit")) {
      Object obj = map.get("sWeightUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSWeightUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sTotalWeight")) {
      Object obj = map.get("sTotalWeight");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSTotalWeight((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sPackageSize")) {
      Object obj = map.get("sPackageSize");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSPackageSize((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sPackageQty")) {
      Object obj = map.get("sPackageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sPackageUnit")) {
      Object obj = map.get("sPackageUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSPackageUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sPackageUnitPriceWithoutTax")) {
      Object obj = map.get("sPackageUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSPackageUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSPackageUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sPackageUnitPriceWithTax")) {
      Object obj = map.get("sPackageUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSPackageUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSPackageUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSPackageUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSPackageUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSPackageUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sPackageMinOrdQty")) {
      Object obj = map.get("sPackageMinOrdQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSPackageMinOrdQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSPackageMinOrdQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSPackageMinOrdQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSPackageMinOrdQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSPackageMinOrdQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sUnitRules")) {
      Object obj = map.get("sUnitRules");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSUnitRules((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sUnit")) {
      Object obj = map.get("sUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sQty")) {
      Object obj = map.get("sQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sUnitPriceWithoutTax")) {
      Object obj = map.get("sUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sUnitPriceWithTax")) {
      Object obj = map.get("sUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sUnitPriceMax")) {
      Object obj = map.get("sUnitPriceMax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSUnitPriceMax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSUnitPriceMax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSUnitPriceMax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSUnitPriceMax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSUnitPriceMax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sUnitPriceMin")) {
      Object obj = map.get("sUnitPriceMin");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSUnitPriceMin((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSUnitPriceMin(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSUnitPriceMin(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSUnitPriceMin(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSUnitPriceMin(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sAmountWithTax")) {
      Object obj = map.get("sAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sAmountWithoutTax")) {
      Object obj = map.get("sAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sTaxType")) {
      Object obj = map.get("sTaxType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSTaxType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sTaxRate")) {
      Object obj = map.get("sTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sDiscountRate")) {
      Object obj = map.get("sDiscountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sPromtFlag")) {
      Object obj = map.get("sPromtFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSPromtFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sFreeFlag")) {
      Object obj = map.get("sFreeFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSFreeFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSuitFlag")) {
      Object obj = map.get("sSuitFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSuitFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSuitInfo")) {
      Object obj = map.get("sSuitInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSuitInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sNewOldFlag")) {
      Object obj = map.get("sNewOldFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSNewOldFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sNewOldInfo")) {
      Object obj = map.get("sNewOldInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSNewOldInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sMinOrdQty")) {
      Object obj = map.get("sMinOrdQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSMinOrdQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSMinOrdQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSMinOrdQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSMinOrdQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSMinOrdQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategoryCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("categoryDesc")) {
      Object obj = map.get("categoryDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategoryDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCategoryCode")) {
      Object obj = map.get("sCategoryCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCategoryCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCategoryDesc")) {
      Object obj = map.get("sCategoryDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCategoryDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomUnit")) {
      Object obj = map.get("sCustomUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomUnit((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("headId.id")) {
        Object obj = map.get("headId.id");
        if(obj instanceof Long) {
          this.setHeadIdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setHeadIdId(Long.parseLong((String)obj));
        }
      }
  }
}
