package com.xforceplus.ultraman.app.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-10-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PointOfSale implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 是否是最新版本
   */
  private Boolean latest;

  /**
   * 原始单据Id数组
   */
  private String srcids;

  /**
   * 所属租户
   */
  @TableField("belongTenant")
  private String belongTenant;

  /**
   * 采集批次
   */
  @TableField("collectionBatch")
  private String collectionBatch;

  /**
   * 商超账号
   */
  @TableField("collectionAccount")
  private String collectionAccount;

  /**
   * 统计类型
   */
  @TableField("statisticalType")
  private String statisticalType;

  /**
   * 销售年份
   */
  @TableField("salesYear")
  private String salesYear;

  /**
   * 销售月份
   */
  @TableField("salesMonth")
  private String salesMonth;

  /**
   * 销售周
   */
  @TableField("salesWeek")
  private String salesWeek;

  /**
   * 购方门店编码
   */
  @TableField("purchaseStoreCode")
  private String purchaseStoreCode;

  /**
   * 购方门店名称
   */
  @TableField("purchaseStoreName")
  private String purchaseStoreName;

  /**
   * 购方公司名称
   */
  @TableField("purchaseCompanyName")
  private String purchaseCompanyName;

  /**
   * 购方公司编码
   */
  @TableField("purchaseCompanyCode")
  private String purchaseCompanyCode;

  /**
   * 零售商编码
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 零售商描述
   */
  @TableField("purchaseRetailerName")
  private String purchaseRetailerName;

  /**
   * 购方统一社会信用代码
   */
  @TableField("purchaseCompanyTaxNo")
  private String purchaseCompanyTaxNo;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销方统一社会信用代码
   */
  @TableField("sellerCompanyTaxNo")
  private String sellerCompanyTaxNo;

  /**
   * 购方门店GLN
   */
  @TableField("purchaseStoreGLN")
  private String purchaseStoreGLN;

  /**
   * 区域编码
   */
  @TableField("regionCode")
  private String regionCode;

  /**
   * 区域名称
   */
  @TableField("regionName")
  private String regionName;

  /**
   * 业态编码
   */
  @TableField("purchaseBusinessTypeNo")
  private String purchaseBusinessTypeNo;

  /**
   * 业态名称
   */
  @TableField("purchaseBusinessTypeName")
  private String purchaseBusinessTypeName;

  /**
   * 销方编码
   */
  @TableField("sellerCode")
  private String sellerCode;

  /**
   * 商品编码
   */
  @TableField("itemCode")
  private String itemCode;

  /**
   * 商品条码
   */
  private String barcode;

  /**
   * 品类编码
   */
  @TableField("categoryCode")
  private String categoryCode;

  /**
   * 品类名称
   */
  @TableField("categoryName")
  private String categoryName;

  /**
   * 品牌
   */
  private String brand;

  /**
   * 商品子编码
   */
  @TableField("itemSubCode")
  private String itemSubCode;

  /**
   * 商品名称
   */
  @TableField("itemDesc")
  private String itemDesc;

  /**
   * 规格
   */
  private String standards;

  /**
   * 基本单位
   */
  private String unit;

  /**
   * 销售方式
   */
  @TableField("salesType")
  private String salesType;

  /**
   * 销售数量
   */
  @TableField("salesQty")
  private BigDecimal salesQty;

  /**
   * 销售天数
   */
  @TableField("salesDays")
  private BigDecimal salesDays;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 单价（含税）
   */
  @TableField("purchasePriceWithTax")
  private BigDecimal purchasePriceWithTax;

  /**
   * 单价（不含税）
   */
  @TableField("purchasePriceWithoutTax")
  private BigDecimal purchasePriceWithoutTax;

  /**
   * 销售单价（含税）
   */
  @TableField("salesPriceWithTax")
  private BigDecimal salesPriceWithTax;

  /**
   * 销售单价（不含税）
   */
  @TableField("salesPriceWithoutTax")
  private BigDecimal salesPriceWithoutTax;

  /**
   * 商品毛利金额
   */
  @TableField("grossProfit")
  private BigDecimal grossProfit;

  /**
   * 促销金额
   */
  @TableField("promotionAmt")
  private BigDecimal promotionAmt;

  /**
   * 优惠券折扣金额
   */
  @TableField("couponDiscount")
  private BigDecimal couponDiscount;

  /**
   * 备注
   */
  private String remark;

  /**
   * 扩展字段_字符串_1
   */
  private String extstr1;

  /**
   * 扩展字段_字符串_2
   */
  private String extstr2;

  /**
   * 扩展字段_字符串_3
   */
  private String extstr3;

  /**
   * 扩展字段_字符串_4
   */
  private String extstr4;

  /**
   * 扩展字段_字符串_5
   */
  private String extstr5;

  /**
   * 扩展字段_字符串_6
   */
  private String extstr6;

  /**
   * 扩展字段_字符串_7
   */
  private String extstr7;

  /**
   * 扩展字段_字符串_8
   */
  private String extstr8;

  /**
   * 扩展字段_字符串_9
   */
  private String extstr9;

  /**
   * 扩展字段_字符串_10
   */
  private String extstr10;

  /**
   * 模版变量Id
   */
  private String vvariableid;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 销售日
   */
  @TableField("salesDay")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime salesDay;

  /**
   * 转换方式
   */
  @TableField("docTransformer")
  private String docTransformer;

  /**
   * 业务id
   */
  @TableField("pBusinessId")
  private String pBusinessId;

  /**
   * 版本号
   */
  @TableField("versionNo")
  private String versionNo;

  /**
   * 销售金额（含税）
   */
  @TableField("salesAmountWithTax")
  private BigDecimal salesAmountWithTax;

  /**
   * 销售金额（不含税）
   */
  @TableField("salesAmountWithoutTax")
  private BigDecimal salesAmountWithoutTax;

  /**
   * 销方版本号
   */
  @TableField("sVersionNo")
  private String sVersionNo;

  /**
   * 导入批次
   */
  @TableField("importBatch")
  private String importBatch;

  /**
   * 数据来源
   */
  @TableField("sDataSourcesFrom")
  private String sDataSourcesFrom;

  /**
   * 客户编码
   */
  @TableField("sCustomerCode")
  private String sCustomerCode;

  /**
   * 客户名称
   */
  @TableField("sCustomerName")
  private String sCustomerName;

  /**
   * 客户组编码
   */
  @TableField("sCustomerGroupCode")
  private String sCustomerGroupCode;

  /**
   * 客户组名称
   */
  @TableField("sCustomerGroupName")
  private String sCustomerGroupName;

  /**
   * 销售组织编码
   */
  @TableField("sSalesOrganizationCode")
  private String sSalesOrganizationCode;

  /**
   * 销售组织名称
   */
  @TableField("sSalesOrganizationName")
  private String sSalesOrganizationName;

  /**
   * 销售公司编码
   */
  @TableField("sCompanyCode")
  private String sCompanyCode;

  /**
   * 销售公司名称
   */
  @TableField("sCompanyName")
  private String sCompanyName;

  /**
   * 业务单元编码
   */
  @TableField("sBuCode")
  private String sBuCode;

  /**
   * 业务单元名称
   */
  @TableField("sBuName")
  private String sBuName;

  /**
   * 销售组编码
   */
  @TableField("sSalesGroupCode")
  private String sSalesGroupCode;

  /**
   * 销售组名称
   */
  @TableField("sSalesGroupName")
  private String sSalesGroupName;

  /**
   * 产品组编码
   */
  @TableField("sDivisionCode")
  private String sDivisionCode;

  /**
   * 产品组名称
   */
  @TableField("sDivisionName")
  private String sDivisionName;

  /**
   * 分销渠道编码
   */
  @TableField("sDistributionChannelCode")
  private String sDistributionChannelCode;

  /**
   * 分销渠道名称
   */
  @TableField("sDistributionChannelName")
  private String sDistributionChannelName;

  /**
   * 销售部门
   */
  @TableField("sSalesDepartmentName")
  private String sSalesDepartmentName;

  /**
   * 销方商品编码
   */
  @TableField("sItemCode")
  private String sItemCode;

  /**
   * 销方商品条码
   */
  @TableField("sBarcode")
  private String sBarcode;

  /**
   * 销方品牌
   */
  @TableField("sBrand")
  private String sBrand;

  /**
   * 销方商品子编码
   */
  @TableField("sItemSubCode")
  private String sItemSubCode;

  /**
   * 销方商品名称
   */
  @TableField("sItemDesc")
  private String sItemDesc;

  /**
   * 销方是否组套商品
   */
  @TableField("sSuitFlag")
  private String sSuitFlag;

  /**
   * 销方组套商品（数组）
   */
  @TableField("sSuitInfo")
  private String sSuitInfo;

  /**
   * 销方是否新老品
   */
  @TableField("sNewOldFlag")
  private String sNewOldFlag;

  /**
   * 销方新老商品（数组）
   */
  @TableField("sNewOldInfo")
  private String sNewOldInfo;

  /**
   * 销方是否促销
   */
  @TableField("sPromtFlag")
  private String sPromtFlag;

  /**
   * 销方折扣率
   */
  @TableField("sDiscountRate")
  private BigDecimal sDiscountRate;

  /**
   * 销方规格型号
   */
  @TableField("sStandards")
  private String sStandards;

  /**
   * 销方颜色
   */
  @TableField("sColor")
  private String sColor;

  /**
   * 销方尺寸
   */
  @TableField("sSize")
  private String sSize;

  /**
   * 单位转换规则（对象数组）
   */
  @TableField("sUnitRules")
  private String sUnitRules;

  /**
   * 销方批量包装数量
   */
  @TableField("sPackageQty")
  private BigDecimal sPackageQty;

  /**
   * 销方批量包装单位
   */
  @TableField("sPackageUnit")
  private String sPackageUnit;

  /**
   * 销方批量包装规格
   */
  @TableField("sPackageSize")
  private String sPackageSize;

  /**
   * 销方批量包装单价（不含税）
   */
  @TableField("sPackageUnitPriceWithoutTax")
  private BigDecimal sPackageUnitPriceWithoutTax;

  /**
   * 销方批量包装单价（含税）
   */
  @TableField("sPackageUnitPriceWithTax")
  private BigDecimal sPackageUnitPriceWithTax;

  /**
   * 销方单据单位
   */
  @TableField("sUnit")
  private String sUnit;

  /**
   * 销方单据单位数量
   */
  @TableField("sQty")
  private BigDecimal sQty;

  /**
   * 销方单价（不含税）
   */
  @TableField("sUnitPriceWithoutTax")
  private BigDecimal sUnitPriceWithoutTax;

  /**
   * 销方单价（含税）
   */
  @TableField("sUnitPriceWithTax")
  private BigDecimal sUnitPriceWithTax;

  /**
   * 销方总重量
   */
  @TableField("sTotalWeight")
  private BigDecimal sTotalWeight;

  /**
   * 销方销售金额（含税）
   */
  @TableField("sellerSalesAmountWithTax")
  private BigDecimal sellerSalesAmountWithTax;

  /**
   * 销方销售金额（不含税）
   */
  @TableField("sellerSalesAmountWithoutTax")
  private BigDecimal sellerSalesAmountWithoutTax;

  /**
   * 价格方式
   */
  @TableField("priceStatus")
  private Long priceStatus;

  /**
   * 商超原单文件地址
   */
  @TableField("pSourceFileURL")
  private String pSourceFileURL;

  /**
   * 客户商品单位
   */
  @TableField("sCustomUnit")
  private String sCustomUnit;

  /**
   * 统一单据标记
   */
  @TableField("pUnifyDocFlag")
  private Boolean pUnifyDocFlag;

  /**
   * 租户单据标记
   */
  @TableField("pTenantDocFlag")
  private Boolean pTenantDocFlag;

  /**
   * 转换批次号
   */
  @TableField("batchNumberOD2UD")
  private String batchNumberOD2UD;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("latest", latest);
      map.put("srcids", srcids);
      map.put("belongTenant", belongTenant);
      map.put("collectionBatch", collectionBatch);
      map.put("collectionAccount", collectionAccount);
      map.put("statisticalType", statisticalType);
      map.put("salesYear", salesYear);
      map.put("salesMonth", salesMonth);
      map.put("salesWeek", salesWeek);
      map.put("purchaseStoreCode", purchaseStoreCode);
      map.put("purchaseStoreName", purchaseStoreName);
      map.put("purchaseCompanyName", purchaseCompanyName);
      map.put("purchaseCompanyCode", purchaseCompanyCode);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("purchaseCompanyTaxNo", purchaseCompanyTaxNo);
      map.put("sellerName", sellerName);
      map.put("sellerCompanyTaxNo", sellerCompanyTaxNo);
      map.put("purchaseStoreGLN", purchaseStoreGLN);
      map.put("regionCode", regionCode);
      map.put("regionName", regionName);
      map.put("purchaseBusinessTypeNo", purchaseBusinessTypeNo);
      map.put("purchaseBusinessTypeName", purchaseBusinessTypeName);
      map.put("sellerCode", sellerCode);
      map.put("itemCode", itemCode);
      map.put("barcode", barcode);
      map.put("categoryCode", categoryCode);
      map.put("categoryName", categoryName);
      map.put("brand", brand);
      map.put("itemSubCode", itemSubCode);
      map.put("itemDesc", itemDesc);
      map.put("standards", standards);
      map.put("unit", unit);
      map.put("salesType", salesType);
      map.put("salesQty", salesQty);
      map.put("salesDays", salesDays);
      map.put("taxRate", taxRate);
      map.put("purchasePriceWithTax", purchasePriceWithTax);
      map.put("purchasePriceWithoutTax", purchasePriceWithoutTax);
      map.put("salesPriceWithTax", salesPriceWithTax);
      map.put("salesPriceWithoutTax", salesPriceWithoutTax);
      map.put("grossProfit", grossProfit);
      map.put("promotionAmt", promotionAmt);
      map.put("couponDiscount", couponDiscount);
      map.put("remark", remark);
      map.put("extstr1", extstr1);
      map.put("extstr2", extstr2);
      map.put("extstr3", extstr3);
      map.put("extstr4", extstr4);
      map.put("extstr5", extstr5);
      map.put("extstr6", extstr6);
      map.put("extstr7", extstr7);
      map.put("extstr8", extstr8);
      map.put("extstr9", extstr9);
      map.put("extstr10", extstr10);
      map.put("vvariableid", vvariableid);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("salesDay", BocpGenUtils.toTimestamp(salesDay));
      map.put("docTransformer", docTransformer);
      map.put("pBusinessId", pBusinessId);
      map.put("versionNo", versionNo);
      map.put("salesAmountWithTax", salesAmountWithTax);
      map.put("salesAmountWithoutTax", salesAmountWithoutTax);
      map.put("sVersionNo", sVersionNo);
      map.put("importBatch", importBatch);
      map.put("sDataSourcesFrom", sDataSourcesFrom);
      map.put("sCustomerCode", sCustomerCode);
      map.put("sCustomerName", sCustomerName);
      map.put("sCustomerGroupCode", sCustomerGroupCode);
      map.put("sCustomerGroupName", sCustomerGroupName);
      map.put("sSalesOrganizationCode", sSalesOrganizationCode);
      map.put("sSalesOrganizationName", sSalesOrganizationName);
      map.put("sCompanyCode", sCompanyCode);
      map.put("sCompanyName", sCompanyName);
      map.put("sBuCode", sBuCode);
      map.put("sBuName", sBuName);
      map.put("sSalesGroupCode", sSalesGroupCode);
      map.put("sSalesGroupName", sSalesGroupName);
      map.put("sDivisionCode", sDivisionCode);
      map.put("sDivisionName", sDivisionName);
      map.put("sDistributionChannelCode", sDistributionChannelCode);
      map.put("sDistributionChannelName", sDistributionChannelName);
      map.put("sSalesDepartmentName", sSalesDepartmentName);
      map.put("sItemCode", sItemCode);
      map.put("sBarcode", sBarcode);
      map.put("sBrand", sBrand);
      map.put("sItemSubCode", sItemSubCode);
      map.put("sItemDesc", sItemDesc);
      map.put("sSuitFlag", sSuitFlag);
      map.put("sSuitInfo", sSuitInfo);
      map.put("sNewOldFlag", sNewOldFlag);
      map.put("sNewOldInfo", sNewOldInfo);
      map.put("sPromtFlag", sPromtFlag);
      map.put("sDiscountRate", sDiscountRate);
      map.put("sStandards", sStandards);
      map.put("sColor", sColor);
      map.put("sSize", sSize);
      map.put("sUnitRules", sUnitRules);
      map.put("sPackageQty", sPackageQty);
      map.put("sPackageUnit", sPackageUnit);
      map.put("sPackageSize", sPackageSize);
      map.put("sPackageUnitPriceWithoutTax", sPackageUnitPriceWithoutTax);
      map.put("sPackageUnitPriceWithTax", sPackageUnitPriceWithTax);
      map.put("sUnit", sUnit);
      map.put("sQty", sQty);
      map.put("sUnitPriceWithoutTax", sUnitPriceWithoutTax);
      map.put("sUnitPriceWithTax", sUnitPriceWithTax);
      map.put("sTotalWeight", sTotalWeight);
      map.put("sellerSalesAmountWithTax", sellerSalesAmountWithTax);
      map.put("sellerSalesAmountWithoutTax", sellerSalesAmountWithoutTax);
      map.put("priceStatus", priceStatus);
      map.put("pSourceFileURL", pSourceFileURL);
      map.put("sCustomUnit", sCustomUnit);
      map.put("pUnifyDocFlag", pUnifyDocFlag);
      map.put("pTenantDocFlag", pTenantDocFlag);
      map.put("batchNumberOD2UD", batchNumberOD2UD);

      return map;
  }

  public static PointOfSale fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PointOfSale entity = new PointOfSale();
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSrcids((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionBatch")) {
      Object obj = map.get("collectionBatch");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionBatch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statisticalType")) {
      Object obj = map.get("statisticalType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatisticalType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesYear")) {
      Object obj = map.get("salesYear");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesMonth")) {
      Object obj = map.get("salesMonth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesWeek")) {
      Object obj = map.get("salesWeek");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesWeek((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryName")) {
      Object obj = map.get("categoryName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSubCode")) {
      Object obj = map.get("itemSubCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesType")) {
      Object obj = map.get("salesType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesQty")) {
      Object obj = map.get("salesQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesDays")) {
      Object obj = map.get("salesDays");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesDays((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesDays(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesDays(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesDays(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesDays(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchasePriceWithTax")) {
      Object obj = map.get("purchasePriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPurchasePriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPurchasePriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPurchasePriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchasePriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchasePriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchasePriceWithoutTax")) {
      Object obj = map.get("purchasePriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPurchasePriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPurchasePriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPurchasePriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchasePriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchasePriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesPriceWithTax")) {
      Object obj = map.get("salesPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesPriceWithoutTax")) {
      Object obj = map.get("salesPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("grossProfit")) {
      Object obj = map.get("grossProfit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGrossProfit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGrossProfit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGrossProfit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGrossProfit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGrossProfit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promotionAmt")) {
      Object obj = map.get("promotionAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPromotionAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPromotionAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPromotionAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPromotionAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPromotionAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("couponDiscount")) {
      Object obj = map.get("couponDiscount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCouponDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCouponDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCouponDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCouponDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCouponDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr1")) {
      Object obj = map.get("extstr1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr2")) {
      Object obj = map.get("extstr2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr3")) {
      Object obj = map.get("extstr3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr4")) {
      Object obj = map.get("extstr4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr5")) {
      Object obj = map.get("extstr5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr6")) {
      Object obj = map.get("extstr6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr7")) {
      Object obj = map.get("extstr7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr8")) {
      Object obj = map.get("extstr8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr9")) {
      Object obj = map.get("extstr9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr10")) {
      Object obj = map.get("extstr10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVvariableid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesDay")) {
      Object obj = map.get("salesDay");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSalesDay(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSalesDay((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesDay(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSalesDay(null);
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocTransformer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesAmountWithTax")) {
      Object obj = map.get("salesAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesAmountWithoutTax")) {
      Object obj = map.get("salesAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sVersionNo")) {
      Object obj = map.get("sVersionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("importBatch")) {
      Object obj = map.get("importBatch");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setImportBatch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDataSourcesFrom")) {
      Object obj = map.get("sDataSourcesFrom");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDataSourcesFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerCode")) {
      Object obj = map.get("sCustomerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerName")) {
      Object obj = map.get("sCustomerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroupCode")) {
      Object obj = map.get("sCustomerGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroupName")) {
      Object obj = map.get("sCustomerGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationCode")) {
      Object obj = map.get("sSalesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationName")) {
      Object obj = map.get("sSalesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyCode")) {
      Object obj = map.get("sCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyName")) {
      Object obj = map.get("sCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBuCode")) {
      Object obj = map.get("sBuCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBuCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBuName")) {
      Object obj = map.get("sBuName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBuName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupCode")) {
      Object obj = map.get("sSalesGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupName")) {
      Object obj = map.get("sSalesGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDivisionCode")) {
      Object obj = map.get("sDivisionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDivisionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDivisionName")) {
      Object obj = map.get("sDivisionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDivisionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDistributionChannelCode")) {
      Object obj = map.get("sDistributionChannelCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDistributionChannelCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDistributionChannelName")) {
      Object obj = map.get("sDistributionChannelName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDistributionChannelName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesDepartmentName")) {
      Object obj = map.get("sSalesDepartmentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sItemCode")) {
      Object obj = map.get("sItemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBarcode")) {
      Object obj = map.get("sBarcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBrand")) {
      Object obj = map.get("sBrand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sItemSubCode")) {
      Object obj = map.get("sItemSubCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sItemDesc")) {
      Object obj = map.get("sItemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSuitFlag")) {
      Object obj = map.get("sSuitFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSuitFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSuitInfo")) {
      Object obj = map.get("sSuitInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSuitInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sNewOldFlag")) {
      Object obj = map.get("sNewOldFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSNewOldFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sNewOldInfo")) {
      Object obj = map.get("sNewOldInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSNewOldInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPromtFlag")) {
      Object obj = map.get("sPromtFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPromtFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDiscountRate")) {
      Object obj = map.get("sDiscountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sStandards")) {
      Object obj = map.get("sStandards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sColor")) {
      Object obj = map.get("sColor");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSize")) {
      Object obj = map.get("sSize");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sUnitRules")) {
      Object obj = map.get("sUnitRules");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSUnitRules((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPackageQty")) {
      Object obj = map.get("sPackageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sPackageUnit")) {
      Object obj = map.get("sPackageUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPackageUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPackageSize")) {
      Object obj = map.get("sPackageSize");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPackageSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPackageUnitPriceWithoutTax")) {
      Object obj = map.get("sPackageUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSPackageUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSPackageUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sPackageUnitPriceWithTax")) {
      Object obj = map.get("sPackageUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSPackageUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSPackageUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSPackageUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSPackageUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSPackageUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sUnit")) {
      Object obj = map.get("sUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sQty")) {
      Object obj = map.get("sQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sUnitPriceWithoutTax")) {
      Object obj = map.get("sUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sUnitPriceWithTax")) {
      Object obj = map.get("sUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sTotalWeight")) {
      Object obj = map.get("sTotalWeight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSTotalWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSTotalWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSTotalWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSTotalWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSTotalWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sellerSalesAmountWithTax")) {
      Object obj = map.get("sellerSalesAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSellerSalesAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSellerSalesAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSellerSalesAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerSalesAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerSalesAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sellerSalesAmountWithoutTax")) {
      Object obj = map.get("sellerSalesAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSellerSalesAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSellerSalesAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSellerSalesAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerSalesAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerSalesAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPriceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPriceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPriceStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pSourceFileURL")) {
      Object obj = map.get("pSourceFileURL");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSourceFileURL((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomUnit")) {
      Object obj = map.get("sCustomUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pUnifyDocFlag")) {
      Object obj = map.get("pUnifyDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPUnifyDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPUnifyDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pTenantDocFlag")) {
      Object obj = map.get("pTenantDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPTenantDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPTenantDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("batchNumberOD2UD")) {
      Object obj = map.get("batchNumberOD2UD");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNumberOD2UD((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSrcids((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionBatch")) {
      Object obj = map.get("collectionBatch");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionBatch((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("statisticalType")) {
      Object obj = map.get("statisticalType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatisticalType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesYear")) {
      Object obj = map.get("salesYear");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesYear((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesMonth")) {
      Object obj = map.get("salesMonth");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesMonth((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesWeek")) {
      Object obj = map.get("salesWeek");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesWeek((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreGLN((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseBusinessTypeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseBusinessTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBarcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategoryCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("categoryName")) {
      Object obj = map.get("categoryName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategoryName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemSubCode")) {
      Object obj = map.get("itemSubCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemSubCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStandards((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesType")) {
      Object obj = map.get("salesType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesQty")) {
      Object obj = map.get("salesQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("salesDays")) {
      Object obj = map.get("salesDays");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesDays((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesDays(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesDays(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesDays(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesDays(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("purchasePriceWithTax")) {
      Object obj = map.get("purchasePriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPurchasePriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPurchasePriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPurchasePriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPurchasePriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchasePriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("purchasePriceWithoutTax")) {
      Object obj = map.get("purchasePriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPurchasePriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPurchasePriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPurchasePriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPurchasePriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchasePriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("salesPriceWithTax")) {
      Object obj = map.get("salesPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("salesPriceWithoutTax")) {
      Object obj = map.get("salesPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("grossProfit")) {
      Object obj = map.get("grossProfit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setGrossProfit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setGrossProfit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setGrossProfit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGrossProfit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setGrossProfit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("promotionAmt")) {
      Object obj = map.get("promotionAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPromotionAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPromotionAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPromotionAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPromotionAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPromotionAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("couponDiscount")) {
      Object obj = map.get("couponDiscount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCouponDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCouponDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCouponDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCouponDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCouponDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr1")) {
      Object obj = map.get("extstr1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr2")) {
      Object obj = map.get("extstr2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr3")) {
      Object obj = map.get("extstr3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr4")) {
      Object obj = map.get("extstr4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr5")) {
      Object obj = map.get("extstr5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr6")) {
      Object obj = map.get("extstr6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr7")) {
      Object obj = map.get("extstr7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr8")) {
      Object obj = map.get("extstr8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr9")) {
      Object obj = map.get("extstr9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr10")) {
      Object obj = map.get("extstr10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVvariableid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesDay")) {
      Object obj = map.get("salesDay");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSalesDay(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSalesDay((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesDay(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSalesDay(null);
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocTransformer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesAmountWithTax")) {
      Object obj = map.get("salesAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("salesAmountWithoutTax")) {
      Object obj = map.get("salesAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sVersionNo")) {
      Object obj = map.get("sVersionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("importBatch")) {
      Object obj = map.get("importBatch");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImportBatch((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sDataSourcesFrom")) {
      Object obj = map.get("sDataSourcesFrom");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDataSourcesFrom((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomerCode")) {
      Object obj = map.get("sCustomerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomerName")) {
      Object obj = map.get("sCustomerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomerGroupCode")) {
      Object obj = map.get("sCustomerGroupCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerGroupCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomerGroupName")) {
      Object obj = map.get("sCustomerGroupName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerGroupName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesOrganizationCode")) {
      Object obj = map.get("sSalesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesOrganizationCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesOrganizationName")) {
      Object obj = map.get("sSalesOrganizationName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesOrganizationName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCompanyCode")) {
      Object obj = map.get("sCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCompanyName")) {
      Object obj = map.get("sCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sBuCode")) {
      Object obj = map.get("sBuCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBuCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sBuName")) {
      Object obj = map.get("sBuName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBuName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesGroupCode")) {
      Object obj = map.get("sSalesGroupCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesGroupCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesGroupName")) {
      Object obj = map.get("sSalesGroupName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesGroupName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sDivisionCode")) {
      Object obj = map.get("sDivisionCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDivisionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sDivisionName")) {
      Object obj = map.get("sDivisionName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDivisionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sDistributionChannelCode")) {
      Object obj = map.get("sDistributionChannelCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDistributionChannelCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sDistributionChannelName")) {
      Object obj = map.get("sDistributionChannelName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDistributionChannelName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesDepartmentName")) {
      Object obj = map.get("sSalesDepartmentName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesDepartmentName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sItemCode")) {
      Object obj = map.get("sItemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sBarcode")) {
      Object obj = map.get("sBarcode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBarcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sBrand")) {
      Object obj = map.get("sBrand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sItemSubCode")) {
      Object obj = map.get("sItemSubCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSItemSubCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sItemDesc")) {
      Object obj = map.get("sItemDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSItemDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSuitFlag")) {
      Object obj = map.get("sSuitFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSuitFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSuitInfo")) {
      Object obj = map.get("sSuitInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSuitInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sNewOldFlag")) {
      Object obj = map.get("sNewOldFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSNewOldFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sNewOldInfo")) {
      Object obj = map.get("sNewOldInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSNewOldInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sPromtFlag")) {
      Object obj = map.get("sPromtFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSPromtFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sDiscountRate")) {
      Object obj = map.get("sDiscountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sStandards")) {
      Object obj = map.get("sStandards");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSStandards((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sColor")) {
      Object obj = map.get("sColor");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSColor((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSize")) {
      Object obj = map.get("sSize");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSize((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sUnitRules")) {
      Object obj = map.get("sUnitRules");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSUnitRules((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sPackageQty")) {
      Object obj = map.get("sPackageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sPackageUnit")) {
      Object obj = map.get("sPackageUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSPackageUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sPackageSize")) {
      Object obj = map.get("sPackageSize");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSPackageSize((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sPackageUnitPriceWithoutTax")) {
      Object obj = map.get("sPackageUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSPackageUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSPackageUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sPackageUnitPriceWithTax")) {
      Object obj = map.get("sPackageUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSPackageUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSPackageUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSPackageUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSPackageUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSPackageUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sUnit")) {
      Object obj = map.get("sUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sQty")) {
      Object obj = map.get("sQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sUnitPriceWithoutTax")) {
      Object obj = map.get("sUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sUnitPriceWithTax")) {
      Object obj = map.get("sUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sTotalWeight")) {
      Object obj = map.get("sTotalWeight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSTotalWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSTotalWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSTotalWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSTotalWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSTotalWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sellerSalesAmountWithTax")) {
      Object obj = map.get("sellerSalesAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSellerSalesAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSellerSalesAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSellerSalesAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSellerSalesAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerSalesAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sellerSalesAmountWithoutTax")) {
      Object obj = map.get("sellerSalesAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSellerSalesAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSellerSalesAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSellerSalesAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSellerSalesAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerSalesAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPriceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPriceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPriceStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("pSourceFileURL")) {
      Object obj = map.get("pSourceFileURL");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSourceFileURL((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomUnit")) {
      Object obj = map.get("sCustomUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pUnifyDocFlag")) {
      Object obj = map.get("pUnifyDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPUnifyDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPUnifyDocFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("pTenantDocFlag")) {
      Object obj = map.get("pTenantDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPTenantDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPTenantDocFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("batchNumberOD2UD")) {
      Object obj = map.get("batchNumberOD2UD");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchNumberOD2UD((String)obj);
        }
      } else {
      }
    }
  }
}
