package com.xforceplus.ultraman.app.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * billing_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-22
 */
public enum BillingType {

    NORMAL("NORMAL", "正常"),
    ADJUSTED("ADJUSTED", "调整"),
    WRITE_OFF("WRITE_OFF", "红冲"),
    CANCEL_WRITE_OFF("CANCEL_WRITE_OFF", "蓝冲"),
    OTHERS("OTHERS", "其他");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillingType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillingType fromCode(String code){
        switch(code) {
            case "NORMAL":
                return NORMAL;
            case "ADJUSTED":
                return ADJUSTED;
            case "WRITE_OFF":
                return WRITE_OFF;
            case "CANCEL_WRITE_OFF":
                return CANCEL_WRITE_OFF;
            case "OTHERS":
                return OTHERS;
            default:
                return null;
        }
    }
}
